% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_complikel.R
\name{psrwe_compl}
\alias{psrwe_compl}
\title{PS-Integrated Composite Likelihood Estimation}
\usage{
psrwe_compl(
  dta_psbor,
  v_outcome = "Y",
  outcome_type = c("continuous", "binary"),
  stderr_method = c("jk", "sjk", "cjk", "sbs", "cbs", "none"),
  n_bootstrap = 200,
  ...
)
}
\arguments{
\item{dta_psbor}{A class \code{PSRWE_BOR} object generated by
\code{\link{psrwe_borrow}}.}

\item{v_outcome}{Column name corresponding to the outcome.}

\item{outcome_type}{Type of outcomes: \code{continuous} or \code{binary}.}

\item{stderr_method}{Method for computing StdErr, see Details}

\item{n_bootstrap}{Number of bootstrap samples (for bootstrap stderr)}

\item{...}{Parameters for \code{rwe_cl}}
}
\value{
A data frame with class name \code{PSRWE_RST}. It contains the
    composite estimation of the mean for each stratum as well as the
    jackknife estimation for each subject. The results can be further
    summarized by its S3 method \code{summary}.
    The results can also be analyzed by \code{psrwe_outana} for outcome
    analysis and inference.
}
\description{
Estimate the mean of the outcome based on PS-integrated composite likelihood
approach. Variance is estimated by the Jackknife method. Applies to the case
when there is only one external data source.
}
\details{
\code{stderr_method} include \code{jk} as default
    using the Jackknife method within each stratum,
    \code{sjk} for simple Jackknife method for combined estimates
    such as point estimates in single-arm or treatment effects in RCT, or
    \code{cjk} for complex Jackknife method including refitting PS model,
    matching, trimming, calculating borrowing parameters, and
    combining overall estimates.
    Note that \code{sjk} may take a while longer to finish and
    \code{cjk} will take even much longer to finish.
    The \code{sbs} and \code{cbs} is for simple and complex Bootstrap
    methods.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
rst       <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst

}
