test_that("Correct outcome format and size for base outcome3",
          {
            skip_if_not_installed("torch")
            skip_if(is.na(tryCatch(cuda_is_available(), error = function(e) NA)))
            outcome3 <- proteus_random_search(2, amzn_aapl_fb, target = c("AMZN", "GOOGL"), future = 15, keep = TRUE, epochs = 3, seed = 64)
            expect_equal(class(outcome3), "list")
            expect_equal(length(outcome3), 4)
            expect_equal(names(outcome3), c("random_search","best", "time_log", "all_models"))
            expect_equal(is.data.frame(outcome3$random_search), TRUE)
            expect_equal(dim(outcome3$random_search), c(2, 21))
            expect_equal(is.list(outcome3$best), TRUE)
            expect_equal(length(outcome3$best), 7)
            expect_equal(dim(outcome3$best$prediction$AMZN), c(15, 16))
            expect_equal(length(outcome3$all_models), 2)
            expect_equal(class(outcome3$time_log)[1],"Period")
          })
