% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan-todo.R
\name{read_todo}
\alias{read_todo}
\title{Read to-do list from YAML}
\usage{
read_todo(input)
}
\arguments{
\item{input}{Either filepath to YAML file or character string. Assumes filepath if ends in ".yml"
and assumes string otherwise.}
}
\value{
List containing plan compatible with \code{post_plan()} or \code{post_todo()}
}
\description{
This function reads a carefully constructed YAML file representing a to-do list (of issues).
YAML is converted into an R list structure which can then be passed to  \code{post_todo()}
to build infrastructure for your repository.
}
\details{
Please see the "Building Custom Plans" vignette for more details.
}
\examples{
\dontrun{
# This example uses example file included in pkg
# You should be able to run example as-is after creating your own repo reference
file_path <- system.file("extdata", "todo.yml", package = "projmgr", mustWork = TRUE)
my_todo <- read_todo(file_path)
post_todo(ref, my_todo)
}
}
\seealso{
Other plans and todos: 
\code{\link{post_plan}()},
\code{\link{post_todo}()},
\code{\link{read_plan}()},
\code{\link{report_plan}()},
\code{\link{report_todo}()},
\code{\link{template_yaml}()}
}
\concept{plans and todos}
