% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.r
\name{parse_rprof}
\alias{parse_rprof}
\title{Parse Rprof output.}
\usage{
parse_rprof(path, interval = 0.02)
}
\arguments{
\item{path}{path to \code{\link{Rprof}} output}

\item{interval}{real-time interval between samples (in seconds)}
}
\value{
\code{\link{data.frame}} of class \code{profr}
}
\description{
Parses the output of \code{\link{Rprof}} into an alternative format
described in \code{\link{profr}}. This produces a flat data frame, which is
somewhat easier to summarise and visualise.
}
\examples{
nesting_ex <- system.file("samples", "nesting.rprof", package="profr")
nesting <- parse_rprof(nesting_ex)

reshape_ex <- system.file("samples", "reshape.rprof", package="profr")
diamonds <- parse_rprof(reshape_ex)
}
\seealso{
\code{\link{profr}} for profiling and parsing
}
\keyword{debugging}
