% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_names.R
\name{make_docker_names}
\alias{make_docker_names}
\title{Generates a random name from the list of Docker adjectives and surnames.}
\usage{
make_docker_names(n, retry = FALSE, sep = "_")
}
\arguments{
\item{n}{The number of random names to be generated.}

\item{retry}{If `TRUE`, a random integer between 1 and 10 is appended to each
generated name.}

\item{sep}{A character string to separate the terms. Not `NA_character_`.}
}
\value{
A random name formatted as "adjective_surname" (for example,
"focused_turing").
}
\description{
This function generates `n` random names, each combining a single adjective
from [docker_adjectives] and a surname from [docker_names].
}
\examples{
make_docker_names(1)
make_docker_names(2, retry = TRUE)
}
