% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_units.R
\name{as_per_km2}
\alias{as_per_km2}
\title{Standardize unit to density per \ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}}
\usage{
as_per_km2(x, unit)
}
\arguments{
\item{x}{\code{numeric} vector.}

\item{unit}{\code{character} vector of spatial units
(e.g., \code{"km2"}, \code{"acres"}, \code{"hectares"}.
For convenience, a single \code{character} value can be specified if all
values in \code{x} are the same unit.}
}
\value{
A \code{numeric} vector.
}
\description{
Standardize number to density per
\ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}.
}
\examples{
as_per_km2(5, "km2")
as_per_km2(5, "acres")
as_per_km2(c(5, 10), "ha")
as_km2(c(5, 10), c("ha", "acres"))

}
