% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal.surface.R
\name{principal.surface}
\alias{principal.surface}
\title{Principal Surface}
\usage{
principal.surface(
  X,
  max.iter = 10,
  alpha = 0.6,
  N = 50,
  print_iterations = FALSE
)
}
\arguments{
\item{X}{A data frame or matrix containing continuous variables.}

\item{max.iter}{Integer. Maximum number of iterations for the principal surface algorithm.}

\item{alpha}{Numeric. The span argument passed to the \code{loess()} function.}

\item{N}{Integer. The resolution for the interpolated grid surface, creating an \eqn{N^2 \times p} matrix.}

\item{print_iterations}{Logical. Should the iterations in the principal surface algorithm be printed? Defaults to \code{FALSE}.}
}
\value{
A list with the following components:
\describe{
\item{\code{fj.mat}}{A numeric \eqn{n \times p} matrix of the final principal surface fitted values.}
\item{\code{lambda.j}}{A numeric representation of the samples in two dimensions.}
}
}
\description{
A function to compute principal surfaces based on input data containing continuous variables.
}
\examples{
\donttest{
surface <- principal.surface(iris[,1:3],max.iter = 3)}
surface <- principal.surface(iris[1:50,1:3],max.iter = 3)
}
