% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bip_stability.R
\name{bip_stability}
\alias{bip_stability}
\title{Bipartite network properties}
\usage{
bip_stability(
  Spp.a = 10:50,
  Spp.p = 5:25,
  C = c(0.05, 0.3),
  IS = NULL,
  quant = FALSE,
  ndd = 1,
  reps = 10
)
}
\arguments{
\item{Spp.a}{numeric vector from which to draw a random number of animal species}

\item{Spp.p}{numeric vector from which to draw a random number of animal species}

\item{C}{numeric two element vector for minimum and maximum possible connectances.}

\item{IS}{mean interaction strength. If NULL, it is calculated as the inverse of the matrix dimension, so that the expected sum of interaction strengths equals one.}

\item{quant}{Logical indicating whether the estimate of modularity should be based on the binary adjacency matrix (FALSE, default), or a quantitative matrix (TRUE).}

\item{ndd}{scalar (1 or 2) determining whether the intraspecific negative density dependence is the same in both networks (1), or is scaled to the interaction sizes in each matrix (2).}

\item{reps}{number of random matrices.}
}
\value{
Returns of list of a matrix with columns for species richness, connectance, nestedness, modularity, and resilience.
}
\description{
A function to calculate the several properties of randomly constructed bipartite networks. This function installation of  packages bipartite, igraph, and rARPACK.
}
\details{
The interaction strengths are exponentially distributed, with mean of IS (rate = 1/IS). Nestedness is WNODF (Almeida-Neto et al. 2011). It can calculate modularity in two ways, using either the binary adjacency matrix (ones and zeroes, Clauset, Newman and Moore 2004) or a quantitative matrix (Beckett 2016); the latter takes much moore time to calculate, so it uses the binary matrix by default. It also tallies diversity as the total number of species and the connectance as the total number of links divided by the number of possible links.

To calculate resilience, the P by A bipartite matrix is expanded to a (P+A) x (P+A) symmetric matrix so the upper triangular portion are the effects of the animals on the plants, and the lower triangular portion is the effects of the plants on the animals.

The diagonal represents intraspecific density dependence; it is filled with the negative of the largest summed row of interaction strengths in the symmetric matrix. The symmatric matrix is interpreted as a Jacobian matrix. Therefore, resilience is the negative value of the real part of the dominant eigen value of the expanded symmetric matrix.
}
\examples{

# b <- bip_stability(Spp.a = 16:60, Spp.p = 8:30, C=c(.05, 0.5), reps=10, quant=FALSE)
# pairs(b)

}
\references{
M. Almeida-Neto and W. Ulrich. A straightforward computational approach for measuring nestedness using quantitative matrices. Environmental Modelling and Software, 26(2):173–178, 2011.

S. J. Beckett. Improved community detection in weighted bipartite networks. Royal Society Open Science, 3:140536, 2016.

A. Clauset, M. E. J. Newman, and M. Cristopher. Finding community structrue in very large networks. Physical Review E, 70:066111, 2004.
}
\author{
Hank Stevens <HankStevens@miamioh.edu>
}
\keyword{methods}
