% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterResults.R
\name{filter_seqs}
\alias{filter_seqs}
\alias{filter_seqs.primerTree}
\title{Filter out sequences retrieved by search_primer_pair() that are either too
short or too long. The alignment and tree will be recalculated after removing
unwanted reads.}
\usage{
filter_seqs(x, ...)

\method{filter_seqs}{primerTree}(x, min_length = 0, max_length = Inf, ...)
}
\arguments{
\item{x}{a primerTree object}

\item{...}{additional arguments passed to methods.}

\item{min_length}{the minimum sequence length to keep}

\item{max_length}{the maximum sequence length to keep}
}
\value{
a primerTree object
}
\description{
Filter out sequences retrieved by search_primer_pair() that are either too
short or too long. The alignment and tree will be recalculated after removing
unwanted reads.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_seqs(primerTree)}: Method for primerTree objects

}}
\examples{
\dontrun{
# filter out sequences longer or shorter than desired:
mammals_16S_filtered <- filter_seqs(mammals_16S, min_length=131, max_length=156)
}
}
