% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateIfunctions.R
\name{calculate_I_rhame}
\alias{calculate_I_rhame}
\title{Function to calculate incidence from PPS data using a Rhame-Sudderth like approach 
with estimates for x.loi and x.los supplied.}
\usage{
calculate_I_rhame(data, x.loi.hat, x.los.hat = NA, method = "rhame")
}
\arguments{
\item{data}{one-row data frame which contains a column A.loi (only used to calculate P.hat) 
with lengths of nosocomial infections up to survey (a 0 indicates no HAI present)}

\item{x.loi.hat}{value for estimated expected length of infection x_loi}

\item{x.los.hat}{value for estimated expected length of stay x_los (optional)}

\item{method}{a string with associated name for method}
}
\value{
one-row data frame with following columns \itemize{
   \item{n - }{number of patients sampled} 
   \item{n.noso - }{number of HAIs}
   \item{P.hat - }{estimate of prevalence P}
   \item{I.hat - }{estimate of incidence rate I}
   \item{I.pp.hat - }{estimate of incidence proportion per admission I.pp}
   \item{x.loi.hat - }{estimate of x.loi}
   \item{x.los.hat - }{estimate of x.los}
   \item{method - }{name of the method}
}
}
\description{
Function to calculate incidence from PPS data using a Rhame-Sudderth like approach 
with estimates for x.loi and x.los supplied.
}
\examples{

# create example data for PPS
example.dist <- create_dist_vec(function(x) dpois(x-1, 7), max.dist = 70)
example.dist.los <- create_dist_vec(function(x) dpois(x-1, lambda = 12),
                                    max.dist = 70)
data.pps.fast <- simulate_pps_fast(n.sample=200,
                                   P=0.05,
                                   dist.X.loi = example.dist,
                                   dist.X.los = example.dist.los)
head(data.pps.fast)

# estimate incidence based on Rhame-Sudderth formula
calculate_I_rhame(data = data.pps.fast,
                   x.loi.hat = 8,
                   x.los.hat = 13)

}
