% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_count.R
\name{onearmglmcount.dr}
\alias{onearmglmcount.dr}
\title{Doubly robust estimators of the coefficients in the two regression}
\usage{
onearmglmcount.dr(y, x.cate, time, trt, ps, f.predictor)
}
\arguments{
\item{y}{Observed outcome; vector of size \code{n}}

\item{x.cate}{Matrix of \code{p} baseline covariates; dimension \code{n} by \code{p}}

\item{time}{Log-transformed person-years of follow-up; vector of size \code{n}}

\item{trt}{Treatment received; vector of size \code{n} units with treatment coded as 0/1}

\item{ps}{Estimated propensity scores for all observations; vector of size \code{n}}

\item{f.predictor}{Initial prediction of the outcome (expected number of relapses for one unit of exposure time) conditioned
on the covariates \code{x} for one treatment group \code{r}; \code{mu_r(x)}, step 1 in the two regression; vector of size \code{n}}
}
\value{
Doubly robust estimators of the regression coefficients \code{beta_r} in the doubly robust estimating equation
where \code{r = 0, 1} is treatment received; vector of size \code{p} + 1 (intercept included)
}
\description{
Doubly robust estimators of the coefficients in the two regression
}
