% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{pbi_schema_create}
\alias{pbi_schema_create}
\title{Create a Power BI dataset schema}
\usage{
pbi_schema_create(
  dt_list,
  dataset_name = "My Power BI Dataset",
  table_name_list,
  relations_list = NULL,
  date_format = "yyyy-mm-dd",
  integer_format = "#,###0",
  double_format = "#,###.00",
  sort_by_col = NULL,
  hidden_col = NULL,
  default_mode = c("Push", "Streaming", "PushStreaming", "AsOnPrem", "AsAzure")
)
}
\arguments{
\item{dt_list}{A list of data frames which the schema should be inferred from.}

\item{dataset_name}{A custom name of the Power BI dataset.}

\item{table_name_list}{A list of custom names corresponding to the list of data
frames.}

\item{relations_list}{A list of relation definitions returned by
pbi_schema_relation_create()}

\item{date_format}{The format of date columns (if any). Default is
'yyyy-mm-dd'.}

\item{integer_format}{The format of integer columns (if any). Default is
'#,###0'.}

\item{double_format}{The format of double columns (if any). Default is
'#,###.00'.}

\item{sort_by_col}{A list of lists of column-sorting definitions. The inner
lists must include elements named 'table', 'sort' and 'sort_by'. See
example for more details.}

\item{hidden_col}{A list of lists columns to be hidden. The inner lists must
include elements named 'table' and 'hidden'. See examples for more details.}

\item{default_mode}{The dataset mode or type. Defaults to 'Push'.}
}
\value{
A list with schema properties.
}
\description{
Creates a Power BI dataset schema from a set of data frames. Columns and data
types will be inferred from the data frames.  Only applicable to push
datasets.
}
\examples{
# Load package
library(powerbiR)

# Use data from the powerbiR package
data(dim_hour)
data(fact_visitors)

# Define dataset and its tables
table_list <- list(fact_visitors, dim_hour)
table_names  <- c("visitors", "hour")
dataset_name <- c("Online Visitors")

# Define relations between tables
relation <- pbi_schema_relation_create(
  from_table = "visitors",
  from_column = "hour_key",
  to_table = "hour"
)

# Define sorting behavior of columns in the hour table
sortlist = list(
  table = c("hour"),
  sort = c("hour"),
  sort_by = c("hour_key")
)

# Hide hour_key in the hour and visitors tables
hidden <- list(
  list(
    table = c("hour"),
    hidden = c("hour_key")
  ),
  list(
    table = c("visitors"),
    hidden = c("hour_key", "visitor_id")
  )
)

# Create schema
schema <- pbi_schema_create(
  dt_list = table_list,
  dataset_name = dataset_name,
  table_name_list = table_names,
  relations_list = list(relation),
  sort_by_col = list(sortlist),
  hidden_col = hidden
)
}
