% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_untranslated_src.R
\name{check_untranslated_src}
\alias{check_untranslated_src}
\title{Check for cracked messages in C/C++ sources}
\usage{
check_untranslated_src(message_data)
}
\arguments{
\item{message_data}{A \code{data.table}, or object convertible to one.}
}
\value{
A \code{data.table} with columns \code{call}, \code{file},
\code{line_number}, and \code{replacement} summarizing the results.
\code{replacement} is \code{NA} at this time, i.e., no replacement is
provided.
}
\description{
Diagnose the C/C++ messages in a package to discover untranslated messages
}
\details{
This diagnostic looks for literal \code{char} arrays passed to messaging
functions (as identified by \code{\link[=translate_package]{translate_package()}}) which are not
marked for translation (by tagging them for translation with \verb{_} or
\code{N_} macros). These strings cannot be translated until they are so
marked.
}
\examples{

pkg <- file.path(system.file(package = 'potools'), 'pkg')
# copy to a temporary location to be able to read/write/update below
tmp_pkg <- file.path(tempdir(), "pkg")
dir.create(tmp_pkg)
file.copy(pkg, dirname(tmp_pkg), recursive = TRUE)

# first, extract message data
message_data = get_message_data(
  tmp_pkg,
  custom_translation_functions = list(src = "ReverseTemplateMessage:2")
)

# now, diagnose the messages for any untranslated messages in C/C++
check_untranslated_src(message_data)

# cleanup
unlink(tmp_pkg, recursive = TRUE)
rm(pkg, tmp_pkg, message_data)
}
\seealso{
\code{\link[=translate_package]{translate_package()}}, \code{\link[=update_pkg_po]{update_pkg_po()}}
}
\author{
Michael Chirico
}
