% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rctglm_methods.R
\name{rctglm_methods}
\alias{rctglm_methods}
\alias{estimand}
\alias{estimand.rctglm}
\alias{est}
\alias{coef.rctglm}
\alias{predict.rctglm}
\alias{print.rctglm}
\title{Methods for objects of class \code{rctglm}}
\usage{
estimand(object)

\method{estimand}{rctglm}(object)

est(object)

\method{coef}{rctglm}(object, ...)

\method{predict}{rctglm}(object, ...)

\method{print}{rctglm}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{an object of class \code{rctglm}}

\item{...}{additional arguments passed to methods}

\item{x}{an object of class \code{rctglm}}

\item{digits}{a \code{numeric} with the number of digits to display when printing}
}
\value{
\code{estimand}/\code{est} returns a \code{data.frame} with columns \code{Estimate} and
\verb{Std. Error} with the estimate and standard error of the estimand.

See \code{\link[=coef]{coef()}} and \code{\link[=predict.glm]{predict.glm()}} for details on what is returned by the corresponding
methods.
}
\description{
Methods mostly to extract information from model fit and inference. See
details for more information on each method.
}
\details{
The function \link{estimand} (or short-hand version \link{est}) can be used to extract
a \code{data.frame} with an estimated value and standard error of the estimand.

A method for the generic \code{\link[=coef]{coef()}} has been added for class \code{rctglm}, which
extracts coefficient information from the underlying \code{glm} fit
in the procedure. The same is true for the method defined for the \code{\link[=predict]{predict()}} generic.
The method for an \code{rctglm} class object calls \code{\link[=predict.glm]{predict.glm()}} on the \code{glm} fit
contained within an \code{rctglm} object.
}
\examples{
# Generate some data to showcase example
n <- 100
exposure_prob <- .5
dat_binom <- glm_data(
  Y ~ 1+1.5*X1+2*A,
  X1 = rnorm(n),
  A = rbinom(n, 1, exposure_prob),
  family = binomial()
)

# Fit the model
ate <- rctglm(formula = Y ~ .,
              exposure_indicator = A,
              exposure_prob = exposure_prob,
              data = dat_binom,
              family = binomial,
              estimand_fun = "ate")

print(ate)
estimand(ate)
coef(ate)
}
\seealso{
The generic \code{\link[=rctglm]{rctglm()}} which produces \code{rctglm} class objects.
}
