% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{polylog_minus_exp_mu}
\alias{polylog_minus_exp_mu}
\title{Polylogarithm function with negative argument}
\usage{
polylog_minus_exp_mu(mu, s, upper = Inf, ...)
}
\arguments{
\item{mu}{vector with exponents of the negative argument.}

\item{s}{vector with indexes of the polylogarithm.}

\item{upper}{upper limit of integration. Defaults to \code{Inf}.}

\item{...}{further arguments passed to \code{\link{integrate}}, such as
\code{upper}, \code{abs.tol}, \code{rel.tol}, etc.}
}
\value{
A vector of size \code{length(mu)} or \code{length(s)} with the
values of the polylogarithm.
}
\description{
Computation of the polylogarithm \eqn{\mathrm{Li}_s(-e^\mu)}.
}
\details{
If \code{s} is an integer, 1/2, 3/2, or 5/2, then routines from
the \href{https://www.gnu.org/software/gsl/}{GSL library} to compute
Fermi--Dirac integrals are called. Otherwise, numerical integration is used.
}
\examples{
polylog_minus_exp_mu(mu = 1:5, s = 1)
polylog_minus_exp_mu(mu = 1, s = 1:5)
polylog_minus_exp_mu(mu = 1:5, s = 1:5)
}
