% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxpartab.R
\name{pmxpartab}
\alias{pmxpartab}
\title{Generate an formatted HTML table of parameter estimates}
\usage{
pmxpartab(
  parframe,
  columns = c(est = "Estimate", rse = "RSE\%", ci95 = "95\% CI", shrinkage =
    "Shrinkage"),
  sections = !is.null(parframe$type),
  section.labels = c(Structural = "Typical Values", CovariateEffect =
    "Covariate Effects", RUV = "Residual Error", IIV = "Between Subject Variability", IOV
    = "Inter-Occasion Variability"),
  footnote = NULL,
  show.fixed.to.zero = FALSE,
  merge.units = TRUE,
  na = "-",
  digits = 3
)
}
\arguments{
\item{parframe}{A \code{data.frame} such as returned by \link{pmxparframe}.}

\item{columns}{A named \code{character} vector of columns to include in the table
(and in what order). The names correspond to column names in \code{parframe} and
the value to the column labels that appear in the formatted table.}

\item{sections}{A \code{logical} indicating whether or not the table should be
formatted into sections according the the \code{type} column of \code{parframe}.}

\item{section.labels}{A named \code{character} vector. The names correspond to
values in the \code{type} column of \code{parframe}, and the values to labels that
appear in the formatted table.}

\item{footnote}{A \code{character} vector of footnotes to place underneath the
formatted table (may contain HTML codes).}

\item{show.fixed.to.zero}{A \code{logical} indicating whether parameters that are
fixed to zero should appear in the formatted table (by default, parameters
that are formatted to values other than zero do appear in the table, but
those that are fixed to zero are ignored).}

\item{merge.units}{A \code{logical} indicating whether or not units (if present)
should be merged into the parameter label (i.e., in parentheses following
the name/label).}

\item{na}{A \code{character} string to use in the formatted table to indicate
missing or non-applicable values.}

\item{digits}{Number of significant digits to include in the formatted
table.}
}
\value{
An object of class \code{"pmxpartab"}. This is essentially just an HTML
character string that displays in the default web browser or viewer when
printed (as per \code{\link[htmltools:print.html]{htmltools::print.html()}}).
}
\description{
Generate an formatted HTML table of parameter estimates
}
\examples{
\donttest{
outputs <- list(
  est = list(
    th = list(CL = 0.482334, VC = 0.0592686),
    om = list(nCL = 0.315414, nVC = 0.536025),
    sg = list(ERRP = 0.0508497)),
  se = list(
    th = list(CL = 0.0138646, VC = 0.00555121),
    om = list(nCL = 0.0188891, nVC = 0.0900352),
    sg = list(ERRP = 0.00182851)),
  fixed = list(
    th = list(CL = FALSE, VC = FALSE),
    om = list(nCL = FALSE, nVC = FALSE),
    sg = list(ERRP = FALSE)),
  shrinkage = list(nCL = 9.54556, nVC = 47.8771))

meta <- list(
  parameters = list(
    list(name="CL", label="Clearance", units="L/h", type="Structural"),
    list(name="VC", label="Volume", units="L", type="Structural", trans="exp"),
    list(name="nCL", label="On Clearance", type="IIV", trans="SD (CV\%)"),
    list(name="nVC", label="On Volume", type="IIV"),
    list(name="ERRP", label="Proportional Error", units="\%", type="RUV", trans="\%")))

pmxpartab(pmxparframe(outputs, meta),
    columns=c(est="Estimate", rse="RSE\%", ci95="95\% CI", shrinkage="Shrinkage"),
    footnote="CI=confidence interval; RSE=relative standard error.")


# An example using a Cox model, where we construct the parframe manually:
library(survival)
cph.fit <- coxph(Surv(time, status) ~ ph.ecog + age, data=lung)
parframe <- with(summary(cph.fit), data.frame(
    name  = c("ph.ecog", "age"),
    label = c("ECOG performance score", "Age"),
    est   = coefficients[,"exp(coef)"],
    pval  = coefficients[,"Pr(>|z|)"],
    lci95 = conf.int[,"lower .95"],
    uci95 = conf.int[,"upper .95"]
))
pmxpartab(parframe=parframe,
    columns=c(est="HR", ci95="95\% CI", pval="P-Value"))
}
}
\seealso{
\link{pmxparframe}
}
