% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_mlx.R
\name{mlx_model_initializer}
\alias{mlx_model_initializer}
\title{Internal: Monolix file initializer}
\usage{
mlx_model_initializer(
  model_name,
  model_file,
  data_file,
  header_types,
  parm_names,
  parm_inis,
  theta_names,
  theta_inis,
  pop = FALSE,
  omega_inis = NULL,
  pre_fixef = NULL,
  obs_types = NULL,
  mapping = NULL
)
}
\arguments{
\item{model_name}{(string) (Path/)Name of generated \emph{.mlxtran} file}

\item{model_file}{(string) (Path/)Name of converted structural model}

\item{data_file}{(string) (Path/)Name of data file to be fitted}

\item{header_types}{(vector) Vector of strings describing column types of data}

\item{parm_names}{(list) List of names of non-NN parameters in the model}

\item{parm_inis}{(list) List of initial values of non-NN parameters}

\item{theta_names}{(list) List of names of NN parameters in the model, i.e., weights and biases}

\item{theta_inis}{(list) List of initial values of NN parameters}

\item{pop}{(boolean) If only population fit without inter-individual variability (TRUE) or individual
fits with inter-individual variability (FALSE) should be used}

\item{omega_inis}{(numeric) Initial standard deviation of random effects on NN parameters; standard 0.1 from nn_converter_mlx}

\item{pre_fixef}{(named vector) Named vector of all initial values to be used for NN and non-NN parameters}

\item{obs_types}{(list) List of types of observations, e.g., \dQuote{continuous}; only required if non-continuous observations}

\item{mapping}{(list) List of mapping between model outputs and observation IDs}
}
\value{
No return value, saving a Monolix .mlxtran file.
}
\description{
Initializes a \emph{.mlxtran} file based on a converted model file, data, and initial values
}
\details{
If no specific file name was given to \emph{nn_converter_mlx} through the \emph{mlx_name} argumen,
the file is standardized to \strong{name of model file}_mlx_file_\strong{pop/ind} where \strong{pop} if \emph{pop=TRUE}
or \strong{ind} if \emph{pop=FALSE} in \emph{nn_converter_mlx}.
}
\author{
Dominic Bräm
}
\keyword{internal}
