% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plu_ral.R
\name{plu_ral}
\alias{plu_ral}
\alias{ral}
\title{Pluralize a phrase based on the length of a vector}
\usage{
plu_ral(
  x,
  vector = NULL,
  n = NULL,
  pl = NULL,
  irregulars = c("moderate", "conservative", "liberal", "none"),
  replace_n = TRUE,
  open = "{",
  close = "}",
  n_fn = lifecycle::deprecated(),
  ...
)

ral(
  x,
  vector = NULL,
  n = NULL,
  pl = NULL,
  irregulars = c("moderate", "conservative", "liberal", "none"),
  replace_n = TRUE,
  open = "{",
  close = "}",
  n_fn = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{x}{A character vector (or vector that can be coerced to character)
of English words or phrase to be pluralized.
See details for special sequences which are handled differently.}

\item{vector}{A vector whose length determines \code{n}. Defaults to \code{NULL}.}

\item{n}{A numeric vector which will determine the plurality of \code{x}.
Defaults to \code{length(vector)}.
If specified, overrides \code{vector}.}

\item{pl}{A logical vector indicating whether to use the plural form (if
\code{TRUE}) or the singular form (if \code{FALSE}) of \code{x}.
Defaults to \code{FALSE} when \code{n} is \code{1} or \code{-1} and \code{TRUE} for all other
values.
If specified, overrides \code{n}.}

\item{irregulars}{What level of irregularity to use in pluralization.
\code{"moderate"} uses the most common pluralization.
\code{"conservative"} uses the most common irregular plural if one exists,
even if a regular plural is more common.
\code{"liberal"} uses a regular plural if it exists, even if an irregular
plural is more common.
\code{"none"} attempts to apply regular noun pluralization rules to all words.
See section "Irregular plurals" for more details.
Defaults to \code{"moderate"}.
The default can be changed by setting \code{options(plu.irregulars)}.
See examples in \code{\link[=ralize]{ralize()}} for more details.}

\item{replace_n}{A logical indicating whether to use special handling for \code{"n"}.
See details.
Defaults to \code{TRUE}.}

\item{open, close}{The opening and closing delimiters for special strings.
See section "Special strings". Defaults to \code{"{"} and \code{"}"}.}

\item{n_fn}{\lifecycle{deprecated}}

\item{...}{\lifecycle{deprecated}}
}
\value{
The character vector \code{x} altered to match the number of \code{n}
}
\description{
Pluralize a phrase based on the length of a vector
}
\section{Irregular plurals}{


Many words in English have both regular and irregular plural forms.
For example, the word "person" can be pluralized as "persons" or "people",
and the word "formula" can be pluralized as "formulas" or "formulae".
\code{plu} offers several options for how to handle words with multiple plurals.
\itemize{
\item The \code{moderate} list attempts to apply the most common pluralization,
whether it is regular or irregular.
This chooses the irregular plural "people" but the regular plural "formulas".
\item The \code{conservative} list attempts to apply an irregular plural to every word
that has one.
This chooses "people" and "formulae", but still uses regular plurals for
words that have no irregular plural form.
\item The \code{liberal} list attempts to apply a regular plural to every word that
has one.
This chooses "persons" and "formulas", but still uses irregular plurals for
words that have no common regular plural, like "women".
Many words in English have invariant plurals that look exactly the same as
their singular forms, like "fish" or "deer".
The \code{liberal} list attempts to use regular plurals for these words,
producing "fishes" and "deers".
\item The \code{none} list applies regular pluralization rules to all words, even
those with no common regular plural.
This produces, for example, "womans" as a plural for "woman" even though this
is not a common English word.
}
}

\section{Special strings}{


Certain strings in \code{x} receive special treatment.
\itemize{
\item By default, \code{"a"} and \code{"an"} are deleted in the plural
("a word" to "words").
\item The string \code{"n"} will be replaced with the length of \code{vector} or the
number in \code{n}.
\item Strings between \code{open} and \code{close} separated by a pipe will be treated as a
custom plural (\code{"{a|some} word"} to "a word", "some words").
\itemize{
\item More than two strings separated by pipes will be treated as singular,
dual, trial, ... and plural forms. For example, \code{"{the|both|all} word"}
to "the word" (1), "both words" (2), "all words" (3+).
\item See examples for more.
}
\item Any other string between \code{open} and \code{close} without a pipe will be treated
as invariant.
For example, \code{"attorney {general}"} to "attorneys general" (notice
"general" is not pluralized).
}
}

\examples{
plu::ral("apple", pl = FALSE)
plu::ral("apple", pl = TRUE)

plu::ral("apple", n = 1)
plu::ral("apple", n = 2)
plu::ral("apple", n = 0)
plu::ral("apple", n = -1)
plu::ral("apple", n = 0.5)

mon <- c("apple")
tue <- c("pear", "pear")

plu::ral("apple", mon)
plu::ral("pear", tue)

paste("Monday, the caterpillar ate", plu::ral("an apple", mon))
paste("Tuesday, the caterpillar ate", plu::ral("a pear", tue))

paste("Monday, the caterpillar visited", plu::ral("an {apple} tree", mon))
paste("Tuesday, the caterpillar visited", plu::ral("a {pear} tree", tue))

paste("Monday, the caterpillar ate", plu::ral("a {single|multiple} apple", mon))
paste("Tuesday, the caterpillar ate", plu::ral("a {single|multiple} pear", tue))

# Vectorized `n`
foods <- c("apple", "pear", "plum", "strawberry", "orange")
quantities <- c(1, 2, 3, 4, 5)
plu::ral(foods, n = quantities)
paste(
  "The caterpillar ate",
  and::and(paste(nombre::cardinal(quantities), plu::ral(foods, n = quantities)))
)

# Some words have a dual form, a specific form for quantities of two
paste("The caterpillar ate", plu::ral("{the|both|all of the} apple", mon))
paste("The caterpillar ate", plu::ral("{the|both|all of the} pear", tue))
paste("The caterpillar ate", plu::ral("{the|both|all of the} delicacy", foods))

# The string "n" will be replaced by the number used for pluralization
paste("The caterpillar ate", plu::ral("n apple", mon))
paste("The caterpillar ate", plu::ral("n delicacy", foods))

# Special brace strings
plu::ral("{one|two}", n = 1)
plu::ral("{one|two}", n = 2)

plu::ral("{one|two|more}", n = 1)
plu::ral("{one|two|more}", n = 2)
plu::ral("{one|two|more}", n = 3)
plu::ral("{one|two|more}", n = 50)

plu::ral("{one|two|three|more}", n = 1)
plu::ral("{one|two|three|more}", n = 2)
plu::ral("{one|two|three|more}", n = 3)
plu::ral("{one|two|three|more}", n = 50)
plu::ral("{one|two|three|more}", n = 0)
plu::ral("{one|two|three|more}", n = 1.5)
}
\seealso{
\code{\link[=plu_ralize]{plu_ralize()}} to convert an English word to its
plural form.
}
