% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vvtz.r
\name{vvtz}
\alias{vvtz}
\title{Projectin operator}
\usage{
vvtz(v, z)
}
\arguments{
\item{v}{orthonormal basis of the space on which \code{z} is projected.
\code{v} is either a matrix or a vector.}

\item{z}{vector that is projected onto the columns of \code{v}}
}
\value{
value of the projection operator
}
\description{
This function computes the projection operator \deqn{P_V z= V V^\top z}
}
\details{
The above formula is only valid if the columns of \code{v} are normalized
and mutually orthogonal.
}
\examples{

# generate random orthogonal vectors
X<-matrix(rnorm(10*100),ncol=10) 	# random data
S<-cor(X) 				# correlation matrix of data
v<-eigen(S)$vectors[,1:3]		# first three eigenvectors of correlation matrix
z<-rnorm(10)				# random vector z
projection.z<-vvtz(v,z)


}
\seealso{
\code{\link{dvvtz}}
}
\author{
Nicole Kraemer
}
\keyword{math}
