% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{findAbsMin}
\alias{findAbsMin}
\title{Return the value (or the element with the value) closest to zero.}
\usage{
findAbsMin(x, element = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{element}{Logical: whether or not to return the value (FALSE, default) 
or the index (TRUE).}
}
\value{
The value or index of the element closest to zero (absolute 
minimum).
}
\description{
Return the value (or the element with the value) closest to zero.
}
\examples{
(test <- seq(-25,25, by=3))
min(test[test>0])
max(test[test<0])
min(abs(test))
findAbsMin(test)
}
\seealso{
Other Utility functions: 
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{getRatioCoords}()},
\code{\link{get_palette}()},
\code{\link{group_sort}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{keepFigRatio}()},
\code{\link{list2str}()},
\code{\link{move_n_point}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()},
\code{\link{sortGroups}()}
}
\author{
Jacolien van Rij
}
\concept{Utility functions}
