% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-functions.R
\name{run_pioneer}
\alias{run_pioneer}
\title{Run pioneeR}
\usage{
run_pioneer(x = NULL, port = NULL, ...)
}
\arguments{
\item{x}{A data frame that should be loaded with the app. See details.}

\item{port}{Integer. The TCP port that the application should listen on.}

\item{...}{Other arguments to send to \code{\link[shiny:runApp]{shiny::runApp()}}.}
}
\value{
None
}
\description{
Run the pioneeR app on your local machine.
}
\details{
Note that pioneeR must be loaded into the namespace with \code{library(pioneeR)}
before you run the pioneeR app.

You can load a data object in your current environment to the app. You can pass
a data frame or a character string with the object name of the data frame you
want to be loaded when the app launches. Note that you should only use data
frame objects. If you have a tibble (from the tidyverse) or a data table, you
can convert to an ordinary data.frame using \code{\link[=as.data.frame]{as.data.frame()}}
}
\examples{
# Only run this example in interactive R sessions
if (interactive()) {
  df = deaR::Electric_plants
  # Load app with data.frame and set port to 8080
  run_pioneer(x = df, port = 8080)
}
}
