% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_malmquist.R
\name{compute_malmquist}
\alias{compute_malmquist}
\title{Compute Malmquist}
\usage{
compute_malmquist(data, input, output, id, time, orientation = c("in", "out"))
}
\arguments{
\item{data}{Dataset to analyse.}

\item{input}{A character vector with input variables.}

\item{output}{A character vector with output variables.}

\item{id}{A string with the DMU id or name variable.}

\item{time}{A string with the time period variable.}

\item{orientation}{Model orientation.}
}
\value{
A list of class \code{pioneer_mlm}
}
\description{
Calculate the Malmquist productivity index and its components using Data
Envelopment Analysis.
}
\details{
Results are returned \emph{a la} Farrell. This implies that for output-oriented models
values above one signify improvements in productivity, while values less than
one imply deterioration in productivity. For input-oriented models the
interpretation is reversed; values less than one denote improvements
and values above one denote deterioration.

Note that \code{compute_malmquist()} only works for balanced panel datasets.
}
\examples{
# Load example data
chnEconomy <- deaR::EconomyLong
# Estimate Malmquist
mod <- compute_malmquist(
  data = chnEconomy,
  id = 'DMUs',
  time = 'Period',
  input = c('Labor', 'Capital'),
  output = 'GIOV',
  orientation = 'in')
# Print results
print(mod)
# Get summary
summary(mod)
# Convert to data frame
df <- as.data.frame(mod)
}
\references{
Färe, R., Grosskopf, S. (1996). \emph{Intertemporal production frontiers: With dynamic DEA}. Springer.
}
