% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varfreq_freq_logistic.R
\name{varfreq_freq_logistic}
\alias{varfreq_freq_logistic}
\title{Calculate observed variant prevalence at time t given logistic growth}
\usage{
varfreq_freq_logistic(t, p0_v1, r_v1, c_ratio = 1)
}
\arguments{
\item{t}{time step number (e.g., days) at which to calculate prevalence}

\item{p0_v1}{initial variant prevalence (# introductions / infected population size)}

\item{r_v1}{logistic growth rate}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2; default = 1 (no bias)}
}
\value{
scalar giving the variant prevalence at time t
}
\description{
This function calculates the observed variant prevalence after t time steps (e.g., days)
given a logistic growth rate and initial variant prevalence.
}
\examples{
varfreq_freq_logistic(t = 30, p0_v1 = 1/10000, r_v1 = 0.1, c_ratio = 1)

}
\seealso{
Other logistic growth functions: 
\code{\link{varfreq_cdf_logistic}()}

Other variant frequency functions: 
\code{\link{varfreq_cdf_logistic}()},
\code{\link{varfreq_expected_mbias}()},
\code{\link{varfreq_obs_freq}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{logistic growth functions}
\concept{variant frequency functions}
