% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.cladogram}
\alias{as.cladogram}
\title{Apply unweighted branch lengths.}
\usage{
as.cladogram(x)
}
\arguments{
\item{x}{an object of class \code{"dendrogram"}.}
}
\value{
an object of class \code{"dendrogram"}.
}
\description{
This function sets the 'height' attributes of all leaf nodes to zero and
  progressively resets the heights of the inner nodes by single incremental
  units in a bottom-up fashion.
}
\examples{
  x <- read.dendrogram(text = "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);")
  plot(x, horiz = TRUE)
  x <- as.cladogram(x)
  plot(x, horiz = TRUE)
}
\author{
Shaun Wilkinson
}
