% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_test.R
\name{one_sample}
\alias{one_sample}
\title{One-sample permutation test}
\usage{
one_sample(x, shift = 0, alternative = "greater", reps = 10^4, seed = NULL)
}
\arguments{
\item{x}{array of data}

\item{shift}{Value of shift to apply in one-sample problem}

\item{alternative}{String, two-sided or one-sided (greater or less) p-value}

\item{reps}{Number of iterations to use when calculating permutation p-value}

\item{seed}{An integer seed value}
}
\value{
The permutation test p-value
}
\description{
This function runs a permutation test for the one-sample problem by calling
the permutation_test function using the one-sample mean test statistic.
}
\examples{
one_sample(x = c(-1, 1, 2), seed = 42)

}
