% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_aa.R
\name{count_aa}
\alias{count_aa}
\title{Count Amino Acids}
\usage{
count_aa(peptides, n = 4)
}
\arguments{
\item{peptides}{A character vector of peptide sequences.}

\item{n}{The number of initial positions to consider in each peptide sequence.}
}
\value{
A data frame with 'n' rows and 20 columns where each row represents a position
in the peptide sequence and each column represents an amino acid. Each cell
in the data frame contains the count of a particular amino acid at a particular position.
}
\description{
This function counts the occurrence of each of the 20 amino acids
at each of the first 'n' positions across a vector of peptide sequences.
}
\examples{
count_aa(c("ACDF", "BCDE", "ABCD"), n = 2)
}
