% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{calculate_weibull_parameters}
\alias{calculate_weibull_parameters}
\title{Calculate Weibull Parameters}
\usage{
calculate_weibull_parameters(given_median, given_first_quartile, delta)
}
\arguments{
\item{given_median}{The median of the data.}

\item{given_first_quartile}{The first quartile of the data.}

\item{delta}{A constant offset value.}
}
\value{
A list containing the calculated Weibull parameters:
\item{alpha}{The shape parameter of the Weibull distribution}
\item{beta}{The scale parameter of the Weibull distribution}
}
\description{
This function calculates the shape (\code{alpha}) and scale (\code{beta}) parameters
of a Weibull distribution given the median, first quartile, and delta values.
}
\examples{
# Calculate Weibull parameters
params <- calculate_weibull_parameters(
  given_median = 50,
  given_first_quartile = 30,
  delta = 15
)
print(params)
}
