% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.edges.triCM}
\alias{rel.edges.triCM}
\title{The indices of the \eqn{CM}-edge regions in a triangle
that contains the points in a give data set}
\usage{
rel.edges.triCM(Xp, tri)
}
\arguments{
\item{Xp}{A set of 2D points representing the set of data points
for which indices of the edge regions
containing them are to be determined.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}
}
\value{
A \code{list} with the elements
\item{re}{Indices (i.e., a \code{vector} of indices) of the edges
whose region contains points in \code{Xp}
in the triangle \code{tri}}
\item{tri}{The vertices of the triangle,
where row number corresponds to the vertex index in \code{rv}.}
\item{desc}{Description of the edge labels as
\code{"Edge labels are AB=3, BC=1, and AC=2"}.}
}
\description{
Returns the indices of the edges
whose regions contain the points in data set \code{Xp} in
a triangle \code{tri}\eqn{=(A,B,C)}
and edge regions are based on the center of mass \eqn{CM} of \code{tri}.
(see the plots in the example for illustrations).

The vertices of the  triangle \code{tri} are labeled as
\eqn{1=A}, \eqn{2=B}, and \eqn{3=C} also
according to the row number the vertex is recorded in \code{tri}
and the corresponding edges are \eqn{1=BC}, \eqn{2=AC}, and \eqn{3=AB}.

If a point in \code{Xp} is not inside \code{tri},
then the function yields \code{NA} as output for that entry.
The corresponding edge region is the polygon
with the vertex, \eqn{CM},
and vertices other than the non-adjacent vertex,
i.e., edge region 1 is the triangle \eqn{T(B,CM,C)},
edge region 2 is \eqn{T(A,CM,C)} and edge region 3 is \eqn{T(A,B,CM)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

P<-c(.4,.2)
rel.edges.triCM(P,Tr)

n<-20  #try also n<-40
set.seed(1)
Xp<-runif.tri(n,Tr)$g

re<-rel.edges.triCM(Xp,Tr)
re
CM<-(A+B+C)/3
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Xp,pch=".",col=1)
L<-Tr; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)

xc<-Tr[,1]+c(-.02,.03,.02)
yc<-Tr[,2]+c(.02,.02,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-rbind(CM,Ds)
xc<-txt[,1]+c(.05,.06,-.05,-.02)
yc<-txt[,2]+c(.03,.03,.05,-.08)
txt.str<-c("CM","re=2","re=3","re=1")
text(xc,yc,txt.str)
text(Xp,labels=factor(re$re))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.edges.tri}}, \code{\link{rel.verts.tri}},
and \code{\link{rel.verts.tri.nondegPE}}
}
\author{
Elvan Ceyhan
}
