% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{print.Extrema}
\alias{print.Extrema}
\title{Print a \code{Extrema} \code{object}}
\usage{
\method{print}{Extrema}(x, ...)
}
\arguments{
\item{x}{A \code{Extrema} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"Extrema"}
and also the \code{type}
(i.e. a brief description) of the extrema).
}
\description{
Prints the \code{call} of the \code{object}
of class \code{"Extrema"}
and also the \code{type}
(i.e. a brief description) of the extrema).
}
\examples{
\donttest{
n<-10
Xp<-runif.std.tri(n)$gen.points
Ext<-cl2edges.std.tri(Xp)
Ext
print(Ext)

typeof(Ext)
attributes(Ext)
}

}
\seealso{
\code{\link{summary.Extrema}},
\code{\link{print.summary.Extrema}},
and \code{\link{plot.Extrema}}
}
