#' @title Welfare caseloads data
#'
#' @description A sample dataset to examine the effects of welfare waiver programs on welfare caseloads in the United States.
#'
#' @usage data(welfare)
#'
#' @format A data frame
#' \describe{
#'   \item{state}{state name}
#'   \item{statenum}{state id}
#'   \item{trend}{time trend in months (oct1986 = 1, nov1986 = 2, etc.)}
#'   \item{treated}{1 if the state is treated, 0 otherwise}
#'   \item{treated_post}{1 if the state is treated and post-intervention, 0 otherwise}
#'   \item{lncase}{Natural log of per-capita welfare caseload}
#'   \item{afdcben}{Maximum combined AFDC/Food Stamps benefits for a family of three (in hundred dollar per month)}
#'   \item{unemp}{unemployment rate}
#'   \item{empratio}{Natural log of employment-to-population ratio}
#'   \item{mon_d2}{seasonal dummy (apr-jun)}
#'   \item{mon_d3}{seasonal dummy (jul-sep}
#'   \item{mon_d4}{seasonal dummy (oct-dec)}
#'   \item{caseload}{welfare caseload}
#'   \item{popn}{population}
#'   \item{empratio_raw}{raw employment-to-population ratio}
#'   \item{south}{1 if the state is in the south, 0 otherwise}
#'   \item{control}{1 if the state is a control unit, 0 otherwise}
#'   \item{T0}{Number of preintervention periods for the state (=117 if control state)}
#' }
#'
#' @references
#' Chan, M. K., & Kwok, S. S. (2022). The PCDID approach: difference-in-differences when trends are potentially unparallel and stochastic. Journal of Business & Economic Statistics, 40(3), 1216-1233.
#'
#' @source
#' Supplemental material, \doi{10.1080/07350015.2021.1914636}
#'
"welfare"
