% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_set_subnets}
\alias{elbv2_set_subnets}
\title{Enables the Availability Zones for the specified public subnets for the
specified Application Load Balancer, Network Load Balancer or Gateway
Load Balancer}
\usage{
elbv2_set_subnets(
  LoadBalancerArn,
  Subnets = NULL,
  SubnetMappings = NULL,
  IpAddressType = NULL,
  EnablePrefixForIpv6SourceNat = NULL
)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{Subnets}{The IDs of the public subnets. You can specify only one subnet per
Availability Zone. You must specify either subnets or subnet mappings.

[Application Load Balancers] You must specify subnets from at least
two Availability Zones.

[Application Load Balancers on Outposts] You must specify one Outpost
subnet.

[Application Load Balancers on Local Zones] You can specify subnets
from one or more Local Zones.

[Network Load Balancers and Gateway Load Balancers] You can specify
subnets from one or more Availability Zones.}

\item{SubnetMappings}{The IDs of the public subnets. You can specify only one subnet per
Availability Zone. You must specify either subnets or subnet mappings.

[Application Load Balancers] You must specify subnets from at least
two Availability Zones. You can't specify Elastic IP addresses for your
subnets.

[Application Load Balancers on Outposts] You must specify one Outpost
subnet.

[Application Load Balancers on Local Zones] You can specify subnets
from one or more Local Zones.

[Network Load Balancers] You can specify subnets from one or more
Availability Zones. You can specify one Elastic IP address per subnet if
you need static IP addresses for your internet-facing load balancer. For
internal load balancers, you can specify one private IP address per
subnet from the IPv4 range of the subnet. For internet-facing load
balancer, you can specify one IPv6 address per subnet.

[Gateway Load Balancers] You can specify subnets from one or more
Availability Zones.}

\item{IpAddressType}{The IP address type.

[Application Load Balancers] The possible values are \code{ipv4} (IPv4
addresses), \code{dualstack} (IPv4 and IPv6 addresses), and
\code{dualstack-without-public-ipv4} (public IPv6 addresses and private IPv4
and IPv6 addresses).

[Network Load Balancers and Gateway Load Balancers] The possible
values are \code{ipv4} (IPv4 addresses) and \code{dualstack} (IPv4 and IPv6
addresses).}

\item{EnablePrefixForIpv6SourceNat}{[Network Load Balancers with UDP listeners] Indicates whether to use
an IPv6 prefix from each subnet for source NAT. The IP address type must
be \code{dualstack}. The default value is \code{off}.}
}
\description{
Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer, Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.

See \url{https://www.paws-r-sdk.com/docs/elbv2_set_subnets/} for full documentation.
}
\keyword{internal}
