# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include backupgateway_service.R
NULL

#' Associates a backup gateway with your server
#'
#' @description
#' Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_associate_gateway_to_server/](https://www.paws-r-sdk.com/docs/backupgateway_associate_gateway_to_server/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway. Use the
#' [`list_gateways`][backupgateway_list_gateways] operation to return a
#' list of gateways for your account and Amazon Web Services Region.
#' @param ServerArn &#91;required&#93; The Amazon Resource Name (ARN) of the server that hosts your virtual
#' machines.
#'
#' @keywords internal
#'
#' @rdname backupgateway_associate_gateway_to_server
backupgateway_associate_gateway_to_server <- function(GatewayArn, ServerArn) {
  op <- new_operation(
    name = "AssociateGatewayToServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$associate_gateway_to_server_input(GatewayArn = GatewayArn, ServerArn = ServerArn)
  output <- .backupgateway$associate_gateway_to_server_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$associate_gateway_to_server <- backupgateway_associate_gateway_to_server

#' Creates a backup gateway
#'
#' @description
#' Creates a backup gateway. After you create a gateway, you can associate it with a server using the [`associate_gateway_to_server`][backupgateway_associate_gateway_to_server] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_create_gateway/](https://www.paws-r-sdk.com/docs/backupgateway_create_gateway/) for full documentation.
#'
#' @param ActivationKey &#91;required&#93; The activation key of the created gateway.
#' @param GatewayDisplayName &#91;required&#93; The display name of the created gateway.
#' @param GatewayType &#91;required&#93; The type of created gateway.
#' @param Tags A list of up to 50 tags to assign to the gateway. Each tag is a
#' key-value pair.
#'
#' @keywords internal
#'
#' @rdname backupgateway_create_gateway
backupgateway_create_gateway <- function(ActivationKey, GatewayDisplayName, GatewayType, Tags = NULL) {
  op <- new_operation(
    name = "CreateGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$create_gateway_input(ActivationKey = ActivationKey, GatewayDisplayName = GatewayDisplayName, GatewayType = GatewayType, Tags = Tags)
  output <- .backupgateway$create_gateway_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$create_gateway <- backupgateway_create_gateway

#' Deletes a backup gateway
#'
#' @description
#' Deletes a backup gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_delete_gateway/](https://www.paws-r-sdk.com/docs/backupgateway_delete_gateway/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway to delete.
#'
#' @keywords internal
#'
#' @rdname backupgateway_delete_gateway
backupgateway_delete_gateway <- function(GatewayArn) {
  op <- new_operation(
    name = "DeleteGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$delete_gateway_input(GatewayArn = GatewayArn)
  output <- .backupgateway$delete_gateway_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$delete_gateway <- backupgateway_delete_gateway

#' Deletes a hypervisor
#'
#' @description
#' Deletes a hypervisor.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_delete_hypervisor/](https://www.paws-r-sdk.com/docs/backupgateway_delete_hypervisor/) for full documentation.
#'
#' @param HypervisorArn &#91;required&#93; The Amazon Resource Name (ARN) of the hypervisor to delete.
#'
#' @keywords internal
#'
#' @rdname backupgateway_delete_hypervisor
backupgateway_delete_hypervisor <- function(HypervisorArn) {
  op <- new_operation(
    name = "DeleteHypervisor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$delete_hypervisor_input(HypervisorArn = HypervisorArn)
  output <- .backupgateway$delete_hypervisor_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$delete_hypervisor <- backupgateway_delete_hypervisor

#' Disassociates a backup gateway from the specified server
#'
#' @description
#' Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_disassociate_gateway_from_server/](https://www.paws-r-sdk.com/docs/backupgateway_disassociate_gateway_from_server/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway to disassociate.
#'
#' @keywords internal
#'
#' @rdname backupgateway_disassociate_gateway_from_server
backupgateway_disassociate_gateway_from_server <- function(GatewayArn) {
  op <- new_operation(
    name = "DisassociateGatewayFromServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$disassociate_gateway_from_server_input(GatewayArn = GatewayArn)
  output <- .backupgateway$disassociate_gateway_from_server_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$disassociate_gateway_from_server <- backupgateway_disassociate_gateway_from_server

#' Retrieves the bandwidth rate limit schedule for a specified gateway
#'
#' @description
#' Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to get a gateway's bandwidth rate limit schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_get_bandwidth_rate_limit_schedule/](https://www.paws-r-sdk.com/docs/backupgateway_get_bandwidth_rate_limit_schedule/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway. Use the
#' [`list_gateways`](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html)
#' operation to return a list of gateways for your account and Amazon Web
#' Services Region.
#'
#' @keywords internal
#'
#' @rdname backupgateway_get_bandwidth_rate_limit_schedule
backupgateway_get_bandwidth_rate_limit_schedule <- function(GatewayArn) {
  op <- new_operation(
    name = "GetBandwidthRateLimitSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$get_bandwidth_rate_limit_schedule_input(GatewayArn = GatewayArn)
  output <- .backupgateway$get_bandwidth_rate_limit_schedule_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$get_bandwidth_rate_limit_schedule <- backupgateway_get_bandwidth_rate_limit_schedule

#' By providing the ARN (Amazon Resource Name), this API returns the
#' gateway
#'
#' @description
#' By providing the ARN (Amazon Resource Name), this API returns the gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_get_gateway/](https://www.paws-r-sdk.com/docs/backupgateway_get_gateway/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway.
#'
#' @keywords internal
#'
#' @rdname backupgateway_get_gateway
backupgateway_get_gateway <- function(GatewayArn) {
  op <- new_operation(
    name = "GetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$get_gateway_input(GatewayArn = GatewayArn)
  output <- .backupgateway$get_gateway_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$get_gateway <- backupgateway_get_gateway

#' This action requests information about the specified hypervisor to which
#' the gateway will connect
#'
#' @description
#' This action requests information about the specified hypervisor to which the gateway will connect. A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_get_hypervisor/](https://www.paws-r-sdk.com/docs/backupgateway_get_hypervisor/) for full documentation.
#'
#' @param HypervisorArn &#91;required&#93; The Amazon Resource Name (ARN) of the hypervisor.
#'
#' @keywords internal
#'
#' @rdname backupgateway_get_hypervisor
backupgateway_get_hypervisor <- function(HypervisorArn) {
  op <- new_operation(
    name = "GetHypervisor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$get_hypervisor_input(HypervisorArn = HypervisorArn)
  output <- .backupgateway$get_hypervisor_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$get_hypervisor <- backupgateway_get_hypervisor

#' This action retrieves the property mappings for the specified hypervisor
#'
#' @description
#' This action retrieves the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_get_hypervisor_property_mappings/](https://www.paws-r-sdk.com/docs/backupgateway_get_hypervisor_property_mappings/) for full documentation.
#'
#' @param HypervisorArn &#91;required&#93; The Amazon Resource Name (ARN) of the hypervisor.
#'
#' @keywords internal
#'
#' @rdname backupgateway_get_hypervisor_property_mappings
backupgateway_get_hypervisor_property_mappings <- function(HypervisorArn) {
  op <- new_operation(
    name = "GetHypervisorPropertyMappings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$get_hypervisor_property_mappings_input(HypervisorArn = HypervisorArn)
  output <- .backupgateway$get_hypervisor_property_mappings_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$get_hypervisor_property_mappings <- backupgateway_get_hypervisor_property_mappings

#' By providing the ARN (Amazon Resource Name), this API returns the
#' virtual machine
#'
#' @description
#' By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_get_virtual_machine/](https://www.paws-r-sdk.com/docs/backupgateway_get_virtual_machine/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the virtual machine.
#'
#' @keywords internal
#'
#' @rdname backupgateway_get_virtual_machine
backupgateway_get_virtual_machine <- function(ResourceArn) {
  op <- new_operation(
    name = "GetVirtualMachine",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$get_virtual_machine_input(ResourceArn = ResourceArn)
  output <- .backupgateway$get_virtual_machine_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$get_virtual_machine <- backupgateway_get_virtual_machine

#' Connect to a hypervisor by importing its configuration
#'
#' @description
#' Connect to a hypervisor by importing its configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_import_hypervisor_configuration/](https://www.paws-r-sdk.com/docs/backupgateway_import_hypervisor_configuration/) for full documentation.
#'
#' @param Host &#91;required&#93; The server host of the hypervisor. This can be either an IP address or a
#' fully-qualified domain name (FQDN).
#' @param KmsKeyArn The Key Management Service for the hypervisor.
#' @param Name &#91;required&#93; The name of the hypervisor.
#' @param Password The password for the hypervisor.
#' @param Tags The tags of the hypervisor configuration to import.
#' @param Username The username for the hypervisor.
#'
#' @keywords internal
#'
#' @rdname backupgateway_import_hypervisor_configuration
backupgateway_import_hypervisor_configuration <- function(Host, KmsKeyArn = NULL, Name, Password = NULL, Tags = NULL, Username = NULL) {
  op <- new_operation(
    name = "ImportHypervisorConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$import_hypervisor_configuration_input(Host = Host, KmsKeyArn = KmsKeyArn, Name = Name, Password = Password, Tags = Tags, Username = Username)
  output <- .backupgateway$import_hypervisor_configuration_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$import_hypervisor_configuration <- backupgateway_import_hypervisor_configuration

#' Lists backup gateways owned by an Amazon Web Services account in an
#' Amazon Web Services Region
#'
#' @description
#' Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_list_gateways/](https://www.paws-r-sdk.com/docs/backupgateway_list_gateways/) for full documentation.
#'
#' @param MaxResults The maximum number of gateways to list.
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `MaxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#'
#' @keywords internal
#'
#' @rdname backupgateway_list_gateways
backupgateway_list_gateways <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Gateways"),
    stream_api = FALSE
  )
  input <- .backupgateway$list_gateways_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .backupgateway$list_gateways_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$list_gateways <- backupgateway_list_gateways

#' Lists your hypervisors
#'
#' @description
#' Lists your hypervisors.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_list_hypervisors/](https://www.paws-r-sdk.com/docs/backupgateway_list_hypervisors/) for full documentation.
#'
#' @param MaxResults The maximum number of hypervisors to list.
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `maxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#'
#' @keywords internal
#'
#' @rdname backupgateway_list_hypervisors
backupgateway_list_hypervisors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHypervisors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Hypervisors"),
    stream_api = FALSE
  )
  input <- .backupgateway$list_hypervisors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .backupgateway$list_hypervisors_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$list_hypervisors <- backupgateway_list_hypervisors

#' Lists the tags applied to the resource identified by its Amazon Resource
#' Name (ARN)
#'
#' @description
#' Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/backupgateway_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource's tags to list.
#'
#' @keywords internal
#'
#' @rdname backupgateway_list_tags_for_resource
backupgateway_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .backupgateway$list_tags_for_resource_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$list_tags_for_resource <- backupgateway_list_tags_for_resource

#' Lists your virtual machines
#'
#' @description
#' Lists your virtual machines.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_list_virtual_machines/](https://www.paws-r-sdk.com/docs/backupgateway_list_virtual_machines/) for full documentation.
#'
#' @param HypervisorArn The Amazon Resource Name (ARN) of the hypervisor connected to your
#' virtual machine.
#' @param MaxResults The maximum number of virtual machines to list.
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `maxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#'
#' @keywords internal
#'
#' @rdname backupgateway_list_virtual_machines
backupgateway_list_virtual_machines <- function(HypervisorArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualMachines",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VirtualMachines"),
    stream_api = FALSE
  )
  input <- .backupgateway$list_virtual_machines_input(HypervisorArn = HypervisorArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .backupgateway$list_virtual_machines_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$list_virtual_machines <- backupgateway_list_virtual_machines

#' This action sets the bandwidth rate limit schedule for a specified
#' gateway
#'
#' @description
#' This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a gateway's bandwidth rate limit schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_put_bandwidth_rate_limit_schedule/](https://www.paws-r-sdk.com/docs/backupgateway_put_bandwidth_rate_limit_schedule/) for full documentation.
#'
#' @param BandwidthRateLimitIntervals &#91;required&#93; An array containing bandwidth rate limit schedule intervals for a
#' gateway. When no bandwidth rate limit intervals have been scheduled, the
#' array is empty.
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway. Use the
#' [`list_gateways`](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html)
#' operation to return a list of gateways for your account and Amazon Web
#' Services Region.
#'
#' @keywords internal
#'
#' @rdname backupgateway_put_bandwidth_rate_limit_schedule
backupgateway_put_bandwidth_rate_limit_schedule <- function(BandwidthRateLimitIntervals, GatewayArn) {
  op <- new_operation(
    name = "PutBandwidthRateLimitSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$put_bandwidth_rate_limit_schedule_input(BandwidthRateLimitIntervals = BandwidthRateLimitIntervals, GatewayArn = GatewayArn)
  output <- .backupgateway$put_bandwidth_rate_limit_schedule_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$put_bandwidth_rate_limit_schedule <- backupgateway_put_bandwidth_rate_limit_schedule

#' This action sets the property mappings for the specified hypervisor
#'
#' @description
#' This action sets the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_put_hypervisor_property_mappings/](https://www.paws-r-sdk.com/docs/backupgateway_put_hypervisor_property_mappings/) for full documentation.
#'
#' @param HypervisorArn &#91;required&#93; The Amazon Resource Name (ARN) of the hypervisor.
#' @param IamRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role.
#' @param VmwareToAwsTagMappings &#91;required&#93; This action requests the mappings of on-premises VMware tags to the
#' Amazon Web Services tags.
#'
#' @keywords internal
#'
#' @rdname backupgateway_put_hypervisor_property_mappings
backupgateway_put_hypervisor_property_mappings <- function(HypervisorArn, IamRoleArn, VmwareToAwsTagMappings) {
  op <- new_operation(
    name = "PutHypervisorPropertyMappings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$put_hypervisor_property_mappings_input(HypervisorArn = HypervisorArn, IamRoleArn = IamRoleArn, VmwareToAwsTagMappings = VmwareToAwsTagMappings)
  output <- .backupgateway$put_hypervisor_property_mappings_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$put_hypervisor_property_mappings <- backupgateway_put_hypervisor_property_mappings

#' Set the maintenance start time for a gateway
#'
#' @description
#' Set the maintenance start time for a gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_put_maintenance_start_time/](https://www.paws-r-sdk.com/docs/backupgateway_put_maintenance_start_time/) for full documentation.
#'
#' @param DayOfMonth The day of the month start maintenance on a gateway.
#' 
#' Valid values range from `Sunday` to `Saturday`.
#' @param DayOfWeek The day of the week to start maintenance on a gateway.
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) for the gateway, used to specify its
#' maintenance start time.
#' @param HourOfDay &#91;required&#93; The hour of the day to start maintenance on a gateway.
#' @param MinuteOfHour &#91;required&#93; The minute of the hour to start maintenance on a gateway.
#'
#' @keywords internal
#'
#' @rdname backupgateway_put_maintenance_start_time
backupgateway_put_maintenance_start_time <- function(DayOfMonth = NULL, DayOfWeek = NULL, GatewayArn, HourOfDay, MinuteOfHour) {
  op <- new_operation(
    name = "PutMaintenanceStartTime",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$put_maintenance_start_time_input(DayOfMonth = DayOfMonth, DayOfWeek = DayOfWeek, GatewayArn = GatewayArn, HourOfDay = HourOfDay, MinuteOfHour = MinuteOfHour)
  output <- .backupgateway$put_maintenance_start_time_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$put_maintenance_start_time <- backupgateway_put_maintenance_start_time

#' This action sends a request to sync metadata across the specified
#' virtual machines
#'
#' @description
#' This action sends a request to sync metadata across the specified virtual machines.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_start_virtual_machines_metadata_sync/](https://www.paws-r-sdk.com/docs/backupgateway_start_virtual_machines_metadata_sync/) for full documentation.
#'
#' @param HypervisorArn &#91;required&#93; The Amazon Resource Name (ARN) of the hypervisor.
#'
#' @keywords internal
#'
#' @rdname backupgateway_start_virtual_machines_metadata_sync
backupgateway_start_virtual_machines_metadata_sync <- function(HypervisorArn) {
  op <- new_operation(
    name = "StartVirtualMachinesMetadataSync",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$start_virtual_machines_metadata_sync_input(HypervisorArn = HypervisorArn)
  output <- .backupgateway$start_virtual_machines_metadata_sync_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$start_virtual_machines_metadata_sync <- backupgateway_start_virtual_machines_metadata_sync

#' Tag the resource
#'
#' @description
#' Tag the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_tag_resource/](https://www.paws-r-sdk.com/docs/backupgateway_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to tag.
#' @param Tags &#91;required&#93; A list of tags to assign to the resource.
#'
#' @keywords internal
#'
#' @rdname backupgateway_tag_resource
backupgateway_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .backupgateway$tag_resource_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$tag_resource <- backupgateway_tag_resource

#' Tests your hypervisor configuration to validate that backup gateway can
#' connect with the hypervisor and its resources
#'
#' @description
#' Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_test_hypervisor_configuration/](https://www.paws-r-sdk.com/docs/backupgateway_test_hypervisor_configuration/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.
#' @param Host &#91;required&#93; The server host of the hypervisor. This can be either an IP address or a
#' fully-qualified domain name (FQDN).
#' @param Password The password for the hypervisor.
#' @param Username The username for the hypervisor.
#'
#' @keywords internal
#'
#' @rdname backupgateway_test_hypervisor_configuration
backupgateway_test_hypervisor_configuration <- function(GatewayArn, Host, Password = NULL, Username = NULL) {
  op <- new_operation(
    name = "TestHypervisorConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$test_hypervisor_configuration_input(GatewayArn = GatewayArn, Host = Host, Password = Password, Username = Username)
  output <- .backupgateway$test_hypervisor_configuration_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$test_hypervisor_configuration <- backupgateway_test_hypervisor_configuration

#' Removes tags from the resource
#'
#' @description
#' Removes tags from the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_untag_resource/](https://www.paws-r-sdk.com/docs/backupgateway_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to remove
#' tags.
#' @param TagKeys &#91;required&#93; The list of tag keys specifying which tags to remove.
#'
#' @keywords internal
#'
#' @rdname backupgateway_untag_resource
backupgateway_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .backupgateway$untag_resource_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$untag_resource <- backupgateway_untag_resource

#' Updates a gateway's name
#'
#' @description
#' Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_update_gateway_information/](https://www.paws-r-sdk.com/docs/backupgateway_update_gateway_information/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway to update.
#' @param GatewayDisplayName The updated display name of the gateway.
#'
#' @keywords internal
#'
#' @rdname backupgateway_update_gateway_information
backupgateway_update_gateway_information <- function(GatewayArn, GatewayDisplayName = NULL) {
  op <- new_operation(
    name = "UpdateGatewayInformation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$update_gateway_information_input(GatewayArn = GatewayArn, GatewayDisplayName = GatewayDisplayName)
  output <- .backupgateway$update_gateway_information_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$update_gateway_information <- backupgateway_update_gateway_information

#' Updates the gateway virtual machine (VM) software
#'
#' @description
#' Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_update_gateway_software_now/](https://www.paws-r-sdk.com/docs/backupgateway_update_gateway_software_now/) for full documentation.
#'
#' @param GatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the gateway to be updated.
#'
#' @keywords internal
#'
#' @rdname backupgateway_update_gateway_software_now
backupgateway_update_gateway_software_now <- function(GatewayArn) {
  op <- new_operation(
    name = "UpdateGatewaySoftwareNow",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$update_gateway_software_now_input(GatewayArn = GatewayArn)
  output <- .backupgateway$update_gateway_software_now_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$update_gateway_software_now <- backupgateway_update_gateway_software_now

#' Updates a hypervisor metadata, including its host, username, and
#' password
#'
#' @description
#' Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/backupgateway_update_hypervisor/](https://www.paws-r-sdk.com/docs/backupgateway_update_hypervisor/) for full documentation.
#'
#' @param Host The updated host of the hypervisor. This can be either an IP address or
#' a fully-qualified domain name (FQDN).
#' @param HypervisorArn &#91;required&#93; The Amazon Resource Name (ARN) of the hypervisor to update.
#' @param LogGroupArn The Amazon Resource Name (ARN) of the group of gateways within the
#' requested log.
#' @param Name The updated name for the hypervisor
#' @param Password The updated password for the hypervisor.
#' @param Username The updated username for the hypervisor.
#'
#' @keywords internal
#'
#' @rdname backupgateway_update_hypervisor
backupgateway_update_hypervisor <- function(Host = NULL, HypervisorArn, LogGroupArn = NULL, Name = NULL, Password = NULL, Username = NULL) {
  op <- new_operation(
    name = "UpdateHypervisor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .backupgateway$update_hypervisor_input(Host = Host, HypervisorArn = HypervisorArn, LogGroupArn = LogGroupArn, Name = Name, Password = Password, Username = Username)
  output <- .backupgateway$update_hypervisor_output()
  config <- get_config()
  svc <- .backupgateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backupgateway$operations$update_hypervisor <- backupgateway_update_hypervisor
