# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ssmsap_service.R
NULL

#' Removes permissions associated with the target database
#'
#' @description
#' Removes permissions associated with the target database.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_delete_resource_permission/](https://www.paws-r-sdk.com/docs/ssmsap_delete_resource_permission/) for full documentation.
#'
#' @param ActionType Delete or restore the permissions on the target database.
#' @param SourceResourceArn The Amazon Resource Name (ARN) of the source resource.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname ssmsap_delete_resource_permission
ssmsap_delete_resource_permission <- function(ActionType = NULL, SourceResourceArn = NULL, ResourceArn) {
  op <- new_operation(
    name = "DeleteResourcePermission",
    http_method = "POST",
    http_path = "/delete-resource-permission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$delete_resource_permission_input(ActionType = ActionType, SourceResourceArn = SourceResourceArn, ResourceArn = ResourceArn)
  output <- .ssmsap$delete_resource_permission_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$delete_resource_permission <- ssmsap_delete_resource_permission

#' Deregister an SAP application with AWS Systems Manager for SAP
#'
#' @description
#' Deregister an SAP application with AWS Systems Manager for SAP. This action does not aﬀect the existing setup of your SAP workloads on Amazon EC2.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_deregister_application/](https://www.paws-r-sdk.com/docs/ssmsap_deregister_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#'
#' @keywords internal
#'
#' @rdname ssmsap_deregister_application
ssmsap_deregister_application <- function(ApplicationId) {
  op <- new_operation(
    name = "DeregisterApplication",
    http_method = "POST",
    http_path = "/deregister-application",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$deregister_application_input(ApplicationId = ApplicationId)
  output <- .ssmsap$deregister_application_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$deregister_application <- ssmsap_deregister_application

#' Gets an application registered with AWS Systems Manager for SAP
#'
#' @description
#' Gets an application registered with AWS Systems Manager for SAP. It also returns the components of the application.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_get_application/](https://www.paws-r-sdk.com/docs/ssmsap_get_application/) for full documentation.
#'
#' @param ApplicationId The ID of the application.
#' @param ApplicationArn The Amazon Resource Name (ARN) of the application.
#' @param AppRegistryArn The Amazon Resource Name (ARN) of the application registry.
#'
#' @keywords internal
#'
#' @rdname ssmsap_get_application
ssmsap_get_application <- function(ApplicationId = NULL, ApplicationArn = NULL, AppRegistryArn = NULL) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "POST",
    http_path = "/get-application",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$get_application_input(ApplicationId = ApplicationId, ApplicationArn = ApplicationArn, AppRegistryArn = AppRegistryArn)
  output <- .ssmsap$get_application_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$get_application <- ssmsap_get_application

#' Gets the component of an application registered with AWS Systems Manager
#' for SAP
#'
#' @description
#' Gets the component of an application registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_get_component/](https://www.paws-r-sdk.com/docs/ssmsap_get_component/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#' @param ComponentId &#91;required&#93; The ID of the component.
#'
#' @keywords internal
#'
#' @rdname ssmsap_get_component
ssmsap_get_component <- function(ApplicationId, ComponentId) {
  op <- new_operation(
    name = "GetComponent",
    http_method = "POST",
    http_path = "/get-component",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$get_component_input(ApplicationId = ApplicationId, ComponentId = ComponentId)
  output <- .ssmsap$get_component_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$get_component <- ssmsap_get_component

#' Gets the SAP HANA database of an application registered with AWS Systems
#' Manager for SAP
#'
#' @description
#' Gets the SAP HANA database of an application registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_get_database/](https://www.paws-r-sdk.com/docs/ssmsap_get_database/) for full documentation.
#'
#' @param ApplicationId The ID of the application.
#' @param ComponentId The ID of the component.
#' @param DatabaseId The ID of the database.
#' @param DatabaseArn The Amazon Resource Name (ARN) of the database.
#'
#' @keywords internal
#'
#' @rdname ssmsap_get_database
ssmsap_get_database <- function(ApplicationId = NULL, ComponentId = NULL, DatabaseId = NULL, DatabaseArn = NULL) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/get-database",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$get_database_input(ApplicationId = ApplicationId, ComponentId = ComponentId, DatabaseId = DatabaseId, DatabaseArn = DatabaseArn)
  output <- .ssmsap$get_database_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$get_database <- ssmsap_get_database

#' Gets the details of an operation by specifying the operation ID
#'
#' @description
#' Gets the details of an operation by specifying the operation ID.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_get_operation/](https://www.paws-r-sdk.com/docs/ssmsap_get_operation/) for full documentation.
#'
#' @param OperationId &#91;required&#93; The ID of the operation.
#'
#' @keywords internal
#'
#' @rdname ssmsap_get_operation
ssmsap_get_operation <- function(OperationId) {
  op <- new_operation(
    name = "GetOperation",
    http_method = "POST",
    http_path = "/get-operation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$get_operation_input(OperationId = OperationId)
  output <- .ssmsap$get_operation_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$get_operation <- ssmsap_get_operation

#' Gets permissions associated with the target database
#'
#' @description
#' Gets permissions associated with the target database.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_get_resource_permission/](https://www.paws-r-sdk.com/docs/ssmsap_get_resource_permission/) for full documentation.
#'
#' @param ActionType 
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname ssmsap_get_resource_permission
ssmsap_get_resource_permission <- function(ActionType = NULL, ResourceArn) {
  op <- new_operation(
    name = "GetResourcePermission",
    http_method = "POST",
    http_path = "/get-resource-permission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$get_resource_permission_input(ActionType = ActionType, ResourceArn = ResourceArn)
  output <- .ssmsap$get_resource_permission_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$get_resource_permission <- ssmsap_get_resource_permission

#' Lists all the applications registered with AWS Systems Manager for SAP
#'
#' @description
#' Lists all the applications registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_list_applications/](https://www.paws-r-sdk.com/docs/ssmsap_list_applications/) for full documentation.
#'
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#' @param Filters The filter of name, value, and operator.
#'
#' @keywords internal
#'
#' @rdname ssmsap_list_applications
ssmsap_list_applications <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/list-applications",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Applications"),
    stream_api = FALSE
  )
  input <- .ssmsap$list_applications_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ssmsap$list_applications_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$list_applications <- ssmsap_list_applications

#' Lists all the components registered with AWS Systems Manager for SAP
#'
#' @description
#' Lists all the components registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_list_components/](https://www.paws-r-sdk.com/docs/ssmsap_list_components/) for full documentation.
#'
#' @param ApplicationId The ID of the application.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#' 
#' If you do not specify a value for MaxResults, the request returns 50
#' items per page by default.
#'
#' @keywords internal
#'
#' @rdname ssmsap_list_components
ssmsap_list_components <- function(ApplicationId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComponents",
    http_method = "POST",
    http_path = "/list-components",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Components"),
    stream_api = FALSE
  )
  input <- .ssmsap$list_components_input(ApplicationId = ApplicationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssmsap$list_components_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$list_components <- ssmsap_list_components

#' Lists the SAP HANA databases of an application registered with AWS
#' Systems Manager for SAP
#'
#' @description
#' Lists the SAP HANA databases of an application registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_list_databases/](https://www.paws-r-sdk.com/docs/ssmsap_list_databases/) for full documentation.
#'
#' @param ApplicationId The ID of the application.
#' @param ComponentId The ID of the component.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value. If you do not specify a value for MaxResults, the request returns
#' 50 items per page by default.
#'
#' @keywords internal
#'
#' @rdname ssmsap_list_databases
ssmsap_list_databases <- function(ApplicationId = NULL, ComponentId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatabases",
    http_method = "POST",
    http_path = "/list-databases",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Databases"),
    stream_api = FALSE
  )
  input <- .ssmsap$list_databases_input(ApplicationId = ApplicationId, ComponentId = ComponentId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssmsap$list_databases_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$list_databases <- ssmsap_list_databases

#' Returns a list of operations events
#'
#' @description
#' Returns a list of operations events.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_list_operation_events/](https://www.paws-r-sdk.com/docs/ssmsap_list_operation_events/) for full documentation.
#'
#' @param OperationId &#91;required&#93; The ID of the operation.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#' 
#' If you do not specify a value for `MaxResults`, the request returns 50
#' items per page by default.
#' @param NextToken The token to use to retrieve the next page of results. This value is
#' null when there are no more results to return.
#' @param Filters Optionally specify filters to narrow the returned operation event items.
#' 
#' Valid filter names include `status`, `resourceID`, and `resourceType`.
#' The valid operator for all three filters is `Equals`.
#'
#' @keywords internal
#'
#' @rdname ssmsap_list_operation_events
ssmsap_list_operation_events <- function(OperationId, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListOperationEvents",
    http_method = "POST",
    http_path = "/list-operation-events",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "OperationEvents"),
    stream_api = FALSE
  )
  input <- .ssmsap$list_operation_events_input(OperationId = OperationId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ssmsap$list_operation_events_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$list_operation_events <- ssmsap_list_operation_events

#' Lists the operations performed by AWS Systems Manager for SAP
#'
#' @description
#' Lists the operations performed by AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_list_operations/](https://www.paws-r-sdk.com/docs/ssmsap_list_operations/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value. If you do not specify a value for MaxResults, the request returns
#' 50 items per page by default.
#' @param NextToken The token for the next page of results.
#' @param Filters The filters of an operation.
#'
#' @keywords internal
#'
#' @rdname ssmsap_list_operations
ssmsap_list_operations <- function(ApplicationId, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListOperations",
    http_method = "POST",
    http_path = "/list-operations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Operations"),
    stream_api = FALSE
  )
  input <- .ssmsap$list_operations_input(ApplicationId = ApplicationId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ssmsap$list_operations_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$list_operations <- ssmsap_list_operations

#' Lists all tags on an SAP HANA application and/or database registered
#' with AWS Systems Manager for SAP
#'
#' @description
#' Lists all tags on an SAP HANA application and/or database registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ssmsap_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname ssmsap_list_tags_for_resource
ssmsap_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ssmsap$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$list_tags_for_resource <- ssmsap_list_tags_for_resource

#' Adds permissions to the target database
#'
#' @description
#' Adds permissions to the target database.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_put_resource_permission/](https://www.paws-r-sdk.com/docs/ssmsap_put_resource_permission/) for full documentation.
#'
#' @param ActionType &#91;required&#93; 
#' @param SourceResourceArn &#91;required&#93; 
#' @param ResourceArn &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname ssmsap_put_resource_permission
ssmsap_put_resource_permission <- function(ActionType, SourceResourceArn, ResourceArn) {
  op <- new_operation(
    name = "PutResourcePermission",
    http_method = "POST",
    http_path = "/put-resource-permission",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$put_resource_permission_input(ActionType = ActionType, SourceResourceArn = SourceResourceArn, ResourceArn = ResourceArn)
  output <- .ssmsap$put_resource_permission_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$put_resource_permission <- ssmsap_put_resource_permission

#' Register an SAP application with AWS Systems Manager for SAP
#'
#' @description
#' Register an SAP application with AWS Systems Manager for SAP. You must meet the following requirements before registering.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_register_application/](https://www.paws-r-sdk.com/docs/ssmsap_register_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#' @param ApplicationType &#91;required&#93; The type of the application.
#' @param Instances &#91;required&#93; The Amazon EC2 instances on which your SAP application is running.
#' @param SapInstanceNumber The SAP instance number of the application.
#' @param Sid The System ID of the application.
#' @param Tags The tags to be attached to the SAP application.
#' @param Credentials The credentials of the SAP application.
#' @param DatabaseArn The Amazon Resource Name of the SAP HANA database.
#' @param ComponentsInfo This is an optional parameter for component details to which the SAP
#' ABAP application is attached, such as Web Dispatcher.
#' 
#' This is an array of ApplicationComponent objects. You may input 0 to 5
#' items.
#'
#' @keywords internal
#'
#' @rdname ssmsap_register_application
ssmsap_register_application <- function(ApplicationId, ApplicationType, Instances, SapInstanceNumber = NULL, Sid = NULL, Tags = NULL, Credentials = NULL, DatabaseArn = NULL, ComponentsInfo = NULL) {
  op <- new_operation(
    name = "RegisterApplication",
    http_method = "POST",
    http_path = "/register-application",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$register_application_input(ApplicationId = ApplicationId, ApplicationType = ApplicationType, Instances = Instances, SapInstanceNumber = SapInstanceNumber, Sid = Sid, Tags = Tags, Credentials = Credentials, DatabaseArn = DatabaseArn, ComponentsInfo = ComponentsInfo)
  output <- .ssmsap$register_application_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$register_application <- ssmsap_register_application

#' Request is an operation which starts an application
#'
#' @description
#' Request is an operation which starts an application.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_start_application/](https://www.paws-r-sdk.com/docs/ssmsap_start_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#'
#' @keywords internal
#'
#' @rdname ssmsap_start_application
ssmsap_start_application <- function(ApplicationId) {
  op <- new_operation(
    name = "StartApplication",
    http_method = "POST",
    http_path = "/start-application",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$start_application_input(ApplicationId = ApplicationId)
  output <- .ssmsap$start_application_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$start_application <- ssmsap_start_application

#' Refreshes a registered application
#'
#' @description
#' Refreshes a registered application.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_start_application_refresh/](https://www.paws-r-sdk.com/docs/ssmsap_start_application_refresh/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#'
#' @keywords internal
#'
#' @rdname ssmsap_start_application_refresh
ssmsap_start_application_refresh <- function(ApplicationId) {
  op <- new_operation(
    name = "StartApplicationRefresh",
    http_method = "POST",
    http_path = "/start-application-refresh",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$start_application_refresh_input(ApplicationId = ApplicationId)
  output <- .ssmsap$start_application_refresh_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$start_application_refresh <- ssmsap_start_application_refresh

#' Request is an operation to stop an application
#'
#' @description
#' Request is an operation to stop an application.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_stop_application/](https://www.paws-r-sdk.com/docs/ssmsap_stop_application/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#' @param StopConnectedEntity Specify the `ConnectedEntityType`. Accepted type is `DBMS`.
#' 
#' If this parameter is included, the connected DBMS (Database Management
#' System) will be stopped.
#' @param IncludeEc2InstanceShutdown Boolean. If included and if set to `True`, the StopApplication operation
#' will shut down the associated Amazon EC2 instance in addition to the
#' application.
#'
#' @keywords internal
#'
#' @rdname ssmsap_stop_application
ssmsap_stop_application <- function(ApplicationId, StopConnectedEntity = NULL, IncludeEc2InstanceShutdown = NULL) {
  op <- new_operation(
    name = "StopApplication",
    http_method = "POST",
    http_path = "/stop-application",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$stop_application_input(ApplicationId = ApplicationId, StopConnectedEntity = StopConnectedEntity, IncludeEc2InstanceShutdown = IncludeEc2InstanceShutdown)
  output <- .ssmsap$stop_application_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$stop_application <- ssmsap_stop_application

#' Creates tag for a resource by specifying the ARN
#'
#' @description
#' Creates tag for a resource by specifying the ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_tag_resource/](https://www.paws-r-sdk.com/docs/ssmsap_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags on a resource.
#'
#' @keywords internal
#'
#' @rdname ssmsap_tag_resource
ssmsap_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ssmsap$tag_resource_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$tag_resource <- ssmsap_tag_resource

#' Delete the tags for a resource
#'
#' @description
#' Delete the tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_untag_resource/](https://www.paws-r-sdk.com/docs/ssmsap_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; Adds/updates or removes credentials for applications registered with AWS
#' Systems Manager for SAP.
#'
#' @keywords internal
#'
#' @rdname ssmsap_untag_resource
ssmsap_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ssmsap$untag_resource_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$untag_resource <- ssmsap_untag_resource

#' Updates the settings of an application registered with AWS Systems
#' Manager for SAP
#'
#' @description
#' Updates the settings of an application registered with AWS Systems Manager for SAP.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmsap_update_application_settings/](https://www.paws-r-sdk.com/docs/ssmsap_update_application_settings/) for full documentation.
#'
#' @param ApplicationId &#91;required&#93; The ID of the application.
#' @param CredentialsToAddOrUpdate The credentials to be added or updated.
#' @param CredentialsToRemove The credentials to be removed.
#' @param Backint Installation of AWS Backint Agent for SAP HANA.
#' @param DatabaseArn The Amazon Resource Name of the SAP HANA database that replaces the
#' current SAP HANA connection with the SAP_ABAP application.
#'
#' @keywords internal
#'
#' @rdname ssmsap_update_application_settings
ssmsap_update_application_settings <- function(ApplicationId, CredentialsToAddOrUpdate = NULL, CredentialsToRemove = NULL, Backint = NULL, DatabaseArn = NULL) {
  op <- new_operation(
    name = "UpdateApplicationSettings",
    http_method = "POST",
    http_path = "/update-application-settings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ssmsap$update_application_settings_input(ApplicationId = ApplicationId, CredentialsToAddOrUpdate = CredentialsToAddOrUpdate, CredentialsToRemove = CredentialsToRemove, Backint = Backint, DatabaseArn = DatabaseArn)
  output <- .ssmsap$update_application_settings_output()
  config <- get_config()
  svc <- .ssmsap$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmsap$operations$update_application_settings <- ssmsap_update_application_settings
