% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_authorize_data_share}
\alias{redshift_authorize_data_share}
\title{From a data producer account, authorizes the sharing of a datashare with
one or more consumer accounts or managing entities}
\usage{
redshift_authorize_data_share(
  DataShareArn,
  ConsumerIdentifier,
  AllowWrites = NULL
)
}
\arguments{
\item{DataShareArn}{[required] The Amazon Resource Name (ARN) of the datashare namespace that producers
are to authorize sharing for.}

\item{ConsumerIdentifier}{[required] The identifier of the data consumer that is authorized to access the
datashare. This identifier is an Amazon Web Services account ID or a
keyword, such as ADX.}

\item{AllowWrites}{If set to true, allows write operations for a datashare.}
}
\description{
From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access permissions.

See \url{https://www.paws-r-sdk.com/docs/redshift_authorize_data_share/} for full documentation.
}
\keyword{internal}
