% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_email_address}
\alias{connect_create_email_address}
\title{Create new email address in the specified Amazon Connect instance}
\usage{
connect_create_email_address(
  Description = NULL,
  InstanceId,
  EmailAddress,
  DisplayName = NULL,
  Tags = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{Description}{The description of the email address.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{EmailAddress}{[required] The email address with the instance, in
[^\\s@]+@[^\\s@]+\\.[^\\s@]+ format.}

\item{DisplayName}{The display name of email address}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Create new email address in the specified Amazon Connect instance. For more information about email addresses, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-email-address1.html}{Create email addresses} in the Amazon Connect Administrator Guide.

See \url{https://www.paws-r-sdk.com/docs/connect_create_email_address/} for full documentation.
}
\keyword{internal}
