% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_purchase_capacity_block}
\alias{ec2_purchase_capacity_block}
\title{Purchase the Capacity Block for use with your account}
\usage{
ec2_purchase_capacity_block(
  DryRun = NULL,
  TagSpecifications = NULL,
  CapacityBlockOfferingId,
  InstancePlatform
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to apply to the Capacity Block during launch.}

\item{CapacityBlockOfferingId}{[required] The ID of the Capacity Block offering.}

\item{InstancePlatform}{[required] The type of operating system for which to reserve capacity.}
}
\description{
Purchase the Capacity Block for use with your account. With Capacity Blocks you ensure GPU capacity is available for machine learning (ML) workloads. You must specify the ID of the Capacity Block offering you are purchasing.

See \url{https://www.paws-r-sdk.com/docs/ec2_purchase_capacity_block/} for full documentation.
}
\keyword{internal}
