% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_ipam_byoasn}
\alias{ec2_associate_ipam_byoasn}
\title{Associates your Autonomous System Number (ASN) with a BYOIP CIDR that
you own in the same Amazon Web Services Region}
\usage{
ec2_associate_ipam_byoasn(DryRun = NULL, Asn, Cidr)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Asn}{[required] A public 2-byte or 4-byte ASN.}

\item{Cidr}{[required] The BYOIP CIDR you want to associate with an ASN.}
}
\description{
Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services Region. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html}{Tutorial: Bring your ASN to IPAM} in the \emph{Amazon VPC IPAM guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_associate_ipam_byoasn/} for full documentation.
}
\keyword{internal}
