% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{rescale_tunnel_data}
\alias{rescale_tunnel_data}
\title{Rescale position data within a \code{viewr} object}
\usage{
rescale_tunnel_data(obj_name, original_scale = 0.5, desired_scale = 1, ...)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"} that has been passed
through \code{relabel_viewr_axes()} and \code{gather_tunnel_data()} (or is
structured as though it has been passed through those functions).}

\item{original_scale}{The original scale at which data were exported. See
Details if unknown.}

\item{desired_scale}{The desired scale}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A \code{viewr} object that has position data (and
\code{mean_marker_error data}, if found) adjusted by the ratio of
\code{desired_scale/original_scale}.
}
\description{
Should data have been exported at an incorrect scale, apply an isometric
transformation to the position data and associated mean marker errors (if
found)
}
\details{
The \code{desired_scale} is divided by the \code{original_scale} to
determine a \code{scale_ratio} internally. If the \code{original_scale} is
not explicitly known, set it to 1 and then set \code{desired_scale} to be
whatever scaling ratio you have in mind. E.g. setting \code{original_scale}
to 1 and then \code{desired_scale} to 0.7 will multiply all position axis
values by 0.7.

The default arguments of \code{original_scale = 0.5} and
\code{desired_scale = 1} apply a doubling of tunnel size isometrically.
}
\examples{
## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "gather" step before running rescale_tunnel_data().
 motive_gathered <-
   motive_data \%>\%
   relabel_viewr_axes() \%>\%
   gather_tunnel_data()

## Now rescale the tunnel data
motive_rescaled <-
  motive_gathered \%>\%
  rescale_tunnel_data(original_scale = 0.5,
                      desired_scale = 1)

## See the difference in data range e.g. for length
range(motive_rescaled$position_length)
range(motive_gathered$position_length)
}
\author{
Vikram B. Baliga
}
