% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{normalizedLermanIndex}
\alias{normalizedLermanIndex}
\alias{normalizedLermanIndex,Partition,Partition,missing-method}
\alias{normalizedLermanIndex,Partition,Partition,PairCoefficients-method}
\title{Normalized Lerman Index}
\usage{
normalizedLermanIndex(p, q, c = NULL)

\S4method{normalizedLermanIndex}{Partition,Partition,missing}(p, q, c = NULL)

\S4method{normalizedLermanIndex}{Partition,Partition,PairCoefficients}(p, q, c = NULL)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}

\item{c}{\linkS4class{PairCoefficients} or NULL}
}
\description{
Compute the normalized Lerman index
\deqn{L(P, Q) / \sqrt{L(P, P)L(Q, Q)}}
where \eqn{L} is the Lerman index.
}
\section{Methods (by class)}{
\itemize{
\item \code{normalizedLermanIndex(p = Partition, q = Partition, c = missing)}: Compute given two partitions

\item \code{normalizedLermanIndex(p = Partition, q = Partition, c = PairCoefficients)}: Compute given the partitions and pair coefficients

}}
\examples{
isTRUE(all.equal(normalizedLermanIndex(new("Partition", c(0, 0, 0, 1, 1)), 
                                       new("Partition", c(0, 0, 1, 1, 1))), 1/6))

}
\references{
\insertRef{Lerman1988}{partitionComparison}

\insertRef{Hubert1985}{partitionComparison}
}
\seealso{
\code{\link{lermanIndex}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
