% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{set_range}
\alias{set_range}
\alias{get_range}
\title{Set items in a \link{LaTeX2} object}
\usage{
set_range(items, range, values)

get_range(items, range)
}
\arguments{
\item{items}{A \link{LaTeX2} object or other list of
\link{LaTeX2item} objects.}

\item{range}{A \link{LaTeX2range} object.}

\item{values}{An object that can be coerced to
a \link{LaTeX2} object or (if \code{range$range} is \code{NULL})
a \link{LaTeX2item}.}
}
\value{
\code{set_range()} replaces the item(s) at the given path, and returns the modified version of \code{items}.

\code{get_range()} extracts the
specified range and returns it as a \link{LaTeX2} object.
}
\description{
Set items in a \link{LaTeX2} object
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex", caption = "Sample table")
parsed <- parseLatex(latex)
tablepath <- path_to(parsed, is_env, envtypes = "tabular")
range <- LaTeX2range(tablepath, 11)
parsed <- set_range(parsed, range, "The 11th item")
parsed
get_range(parsed, range)
}
