% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModelMetric.R
\name{plotModelMetric}
\alias{plotModelMetric}
\title{Plot diagnostics of many initialized PARAFAC models.}
\usage{
plotModelMetric(
  metric,
  plottingMode = "box",
  ylabel = "metric",
  titleString = ""
)
}
\arguments{
\item{metric}{Matrix of metrics per initialized model (number of models x number of components).}

\item{plottingMode}{Plot the metrics as a box plot ("box", default) or as a bar plot ("bar").}

\item{ylabel}{String of the y axis label (default "metric").}

\item{titleString}{String of the plot title (default "").}
}
\value{
A plot of the metrics
}
\description{
Plot diagnostics of many initialized PARAFAC models.
}
\examples{
varExp = array(runif(100*2, min=50, max=100), c(100,2))
plotModelMetric(varExp, plottingMode="box", ylabel="Variation explained (\%)")
}
