% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac.R
\name{parafac}
\alias{parafac}
\title{Parallel Factor Analysis}
\usage{
parafac(
  Tensor,
  nfac,
  nstart = 1,
  maxit = 500,
  ctol = 1e-04,
  initialization = "random",
  output = "best",
  sortComponents = FALSE
)
}
\arguments{
\item{Tensor}{3-way matrix of numeric data}

\item{nfac}{Number of factors (components) to fit.}

\item{nstart}{Number of models to randomly initialize (default 1).}

\item{maxit}{Maximum number of iterations allowed without convergence (default 500).}

\item{ctol}{Relative change in loss tolerated to call the algorithm converged in the ALS case (default 1e-4).}

\item{initialization}{"Random" for randomly initialized input vectors or "nvec" for svd-based best guess.}

\item{output}{String ("best"/"all") Return only the best model of the nstart models ("best") or return all of them in a list object ("all").}

\item{sortComponents}{Boolean to sort the components based on their variance explained (default FALSE)}
}
\value{
List object of the PARAFAC model or models.
}
\description{
Parallel Factor Analysis
}
\examples{
X = array(rnorm(108*100*10), c(108,100,10))
model = parafac(X, 2)
}
