% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializePARAFAC.R
\name{initializePARAFAC}
\alias{initializePARAFAC}
\title{Initialize PARAFAC algorithm input vectors}
\usage{
initializePARAFAC(Tensor, nfac, initialization = "random", output = "Fac")
}
\arguments{
\item{Tensor}{Input dataset matrix or tensor}

\item{nfac}{Number of components to initialize.}

\item{initialization}{Either "random" for random initialization or "svd" for svd based.}

\item{output}{Output the initialized components as a Fac object ("Fac", default) or as a vector ("vect").}
}
\value{
Fac or vector with initialized components.
}
\description{
Initialize PARAFAC algorithm input vectors
}
\examples{
A = array(rnorm(108,2), c(108,2))
B = array(rnorm(100,2), c(100,2))
C = array(rnorm(10,2), c(10,2))
Tensor = reinflateTensor(A, B, C, returnAsTensor=TRUE)
init = initializePARAFAC(Tensor, 2)
}
