% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prices.R
\name{paddle_list_prices}
\alias{paddle_list_prices}
\title{Retrieve a List of Paddle Prices}
\usage{
paddle_list_prices(
  id = NULL,
  product_id = NULL,
  status = NULL,
  include = NULL,
  order_by = NULL,
  per_page = NULL,
  after = NULL,
  recurring = NULL,
  type = NULL
)
}
\arguments{
\item{id}{Character vector of Paddle price IDs (e.g., "pri_abc123"). Optional.}

\item{product_id}{Character vector of Paddle product IDs. Optional.}

\item{status}{Character vector of status filters (e.g., `"active"`, `"archived"`). Optional.}

\item{include}{Character vector of related entities - default `NULL` or `"product"`. Optional.}

\item{order_by}{String specifying sort field and direction (e.g., "id[ASC]"). Valid fields for ordering: `billing_cycle.frequency`, `billing_cycle.interval`, `id`, `product_id`, `quantity.maximum`, `quantity.minimum`, `status`, `tax_mode`, `unit_price.amount`, and `unit_price.currency_code`. Valid directions `"[ASC]"` and `"[DESC]"` Optional.}

\item{per_page}{Number of results per page (max 200). Optional, defaults to 50.}

\item{after}{Return entities after the specified Paddle ID when working with paginated endpoints. Optional.}

\item{recurring}{Logical: TRUE to return recurring prices, FALSE for one-time. Optional.}

\item{type}{Character. Type of item (one of `"standard"` and `"custom"`). Optional.}
}
\value{
A list of price entities and pagination metadata.
}
\description{
Fetches a paginated list of price entities from Paddle. Filters are available
for ID, product, status, recurrence, and ordering. Optionally includes related products.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_prices()
\dontshow{\}) # examplesIf}
}
