% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_load_gh.R
\name{p_load_gh}
\alias{p_load_gh}
\title{Load One or More GitHub Packages}
\usage{
p_load_gh(..., char, install = TRUE, update = getOption("pac_update"),
  dependencies = TRUE)
}
\arguments{
\item{char}{Character vector containing repository address to load.  If you are calling
\code{p_load_gh} from within a function (or just having difficulties calling it 
using a character vector input) then pass your character vector of packages 
to load to this parameter directly.}

\item{install}{logical.  If \code{TRUE} will attempt to install a package not 
found in the library.}

\item{update}{logical.  If \code{TRUE} will attempt to update all out of date 
packages.  Default allows the user to set a \code{"pac_update"} in his/her 
.Rprofile.}

\item{dependencies}{logical.  If \code{TRUE} necessary dependencies will be 
installed as well.}

\item{\ldots}{Repository address(es) in the format 
\code{username/repo[/subdir][@ref|#pull]}.  Note that this must be a character string.}
}
\description{
This function is a wrapper for \code{\link[remotes]{install_github}}
which is the same as \code{\link[devtools]{install_github}} and 
\code{\link[base]{require}}.  It checks to see if a 
package is installed, if not it attempts to install the package from 
\href{https://github.com}{GitHub}.
}
\examples{
\dontrun{
p_load_gh("Dasonk/Dmisc", "trinker/regexr")

p_load_gh(c("trinker/regexTools",
    "hadley/lubridate",
    "ramnathv/rCharts"))
}
}
\seealso{
\code{\link[remotes]{install_github}}
\code{\link[base]{library}},
\code{\link[base]{require}}
}
