% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_psa_darth}
\alias{check_psa_darth}
\title{Check PSA inputs & outputs}
\usage{
check_psa_darth(
  l_psa_darth,
  utility = "u_",
  costs = "c_",
  probs = "p_",
  rr = "rr_",
  hr = "hr_",
  or = "or_",
  exclude = NULL,
  v_outcome = c("effectiveness", "cost")
)
}
\arguments{
\item{l_psa_darth}{a list of class 'psa' as obtained by the function [dampack::make_psa_obj()]}

\item{utility}{characters. String used at the start of the variables identifying utility inputs.}

\item{costs}{characters. String used at the start of the variables identifying cost inputs.}

\item{probs}{characters. String used at the start of the variables identifying probability inputs.}

\item{rr}{characters. String used at the start of the variables identifying relative risk inputs.}

\item{hr}{characters. String used at the start of the variables identifying hazard ratio inputs.}

\item{or}{characters. String used at the start of the variables identifying odds ratio inputs.}

\item{exclude}{vector of strings. Vector containing the name of the input variables not to include in the checks. Default is NULL, hence all variables from the 'parameters' dataframe are included.}

\item{v_outcome}{vector of strings. Vector containing the name of the output variables to include in the checks. Default values are 'effectiveness' and 'cost'.}
}
\value{
A matrix containing the input and output variables that have been checked and the iterations wherein an erroneous value has been identified.
}
\description{
This function checks whether the value of variables remain between 0 and 1 for utility and probability inputs, and are strictly positive for costs, hazard ratios, odds ratios, relative risks, and total outcomes of each strategy.
}
