% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{plot_network}
\alias{plot_network}
\title{Plot stationary network}
\usage{
plot_network(graph, ...)
}
\arguments{
\item{graph}{a tbl_graph object}

\item{...}{other parameters for ggraph}
}
\value{
ggraph
}
\description{
Plot stationary network through ggraph
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
dtw_dist_matrix <- get_dtw_dist_mat(expression_matrix,
                                    pseudotime_list,
                                    cores=1)
nets <- module_networks(dtw_dist_matrix,k=1,quantile_cutoff=50)
plot_network(nets[["module1"]])
}
