% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz_formatting.R
\name{check_question}
\alias{check_question}
\title{Check Quiz Question Set Up}
\usage{
check_question(
  question_df,
  quiz_name = NA,
  verbose = TRUE,
  ignore_coursera = TRUE
)
}
\arguments{
\item{question_df}{Which is an individual question's data frame after being parse from}

\item{quiz_name}{The name of the quiz the question is from}

\item{verbose}{Whether progress messages should be given}

\item{ignore_coursera}{Coursera doesn't like `!` or `:` in the quizzes. Do not convert quizzes to coursera and ignore ! and : in question prompts that would not be allowed in Leanpub quizzes when converted to a Coursera quiz. Default is to ignore Coursera compatibility}
}
\value{
A list of messages/warnings regarding each check for the given question.
}
\description{
Check quiz question set up to see if it is compliant with Leanpub and Coursera needs.
Based off of [Markua guide](https://leanpub.com/markua/read#leanpub-auto-quizzes-and-exercises).
Is called by [ottrpal::check_all_questions] and run for each question.
}
\examples{
\dontrun{

# Use readLines to read in a quiz
quiz_path <- good_quiz_path()
quiz_lines <- readLines(quiz_path)

# Use group_split to get the questions
questions_df <- parse_quiz(quiz_lines)$data \%>\%
  dplyr::group_split(question)

good_quiz_checks <- check_question(questions_df[[2]])
}
}
