% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borrow_chapter.R
\name{borrow_chapter}
\alias{borrow_chapter}
\title{Borrow/link a chapter from another bookdown course}
\usage{
borrow_chapter(
  doc_path,
  repo_name = NULL,
  remove_h1 = FALSE,
  tag_replacement = NULL,
  branch = "main",
  token = NULL,
  base_url = "https://raw.githubusercontent.com",
  dest_dir = file.path("resources", "other_chapters")
)
}
\arguments{
\item{doc_path}{A file path of markdown or R Markdown
document of the chapter in the repository you are retrieving it from that
you would like to include in the current document. e.g "docs/intro.md" or
"intro.md"}

\item{repo_name}{A character vector indicating the repo name of where you are
 borrowing from. e.g. "jhudsl/OTTR_Template/".
For a Wiki of a repo, use "wiki/jhudsl/OTTR_Template/"
If nothing is provided, will look for local file.}

\item{remove_h1}{If TRUE Remove all h1 headers.}

\item{tag_replacement}{An optional list of tags that need to be replaced in
the child document upon bringing it into the render.}

\item{branch}{Default is to pull from main branch, but need to declare if
other branch is needed.}

\item{token}{A personal access token from GitHub. Only necessary if the
repository being checked is a private repository.}

\item{base_url}{it's assumed this is coming from github so it is by default
'https://raw.githubusercontent.com/'}

\item{dest_dir}{A file path where the file should be stored upon arrival to
the current repository.}
}
\value{
An Rmarkdown or markdown is knitted into the document from another repository
}
\description{
If you have two courses that the content and topics overlap,
you may want to share written material between the two.
But, if you copy and paste to share material this would create a maintenance
problem because if you update one you will need to remember to copy over the
other! 
To borrow a chapter from another course, create an .Rmd as you normally would,
 with an [`H1` title](https://www.markdownguide.org/basic-syntax/) if you wish.
Then in a code chunk, use cow::borrow_chapter() to have the content from an
Rmd from another repository knitted into the Rmd.
}
\examples{
\dontrun{

# In an Rmarkdown document:

# For a file in another repository:
# ```{r, echo=FALSE, results='asis'}
borrow_chapter(
  doc_path = "docs/02-chapter_of_course.md",
  repo_name = "jhudsl/OTTR_Template"
)
# ```

# For a local file:
# ```{r, echo=FALSE, results='asis'}
borrow_chapter(doc_path = "02-chapter_of_course.Rmd")
# ```

tag_replacement_list <- list(
  "{A_TAG}" = "replacement here",
  "{TEMPLATE_URL}" = "https://www.ottrproject.org/",
  "{SECOND_TAG}" = "some other replacement here"
)

# For replacing tags
# ```{r, echo=FALSE, results='asis'}
# borrow_chapter(
#  doc_path = "02-chapter_of_course.Rmd",
#  tag_replacement = tag_replacement_list,
# )
# )
# ```
}
}
