% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifications.R
\docType{data}
\name{classifications}
\alias{classifications}
\alias{osm_point_polygon_class}
\alias{osm_line_class}
\alias{osm_line_info_tags}
\title{A Classification of OSM Features by Economic Function}
\format{
An object of class \code{list} of length 33.

An object of class \code{list} of length 11.

An object of class \code{list} of length 11.
}
\usage{
osm_point_polygon_class

osm_line_class

osm_line_info_tags
}
\description{
This classification, developed for Krantz (2023), aims to classify OSM features into meaningful and specific economic
categories such as 'education', 'health', 'tourism', 'financial', 'shopping', 'transport', 'communications',
'industrial', 'residential', 'road', 'railway', 'pipeline', 'power', 'waterway' etc. Separate classifications
are developed for points and polygons (buildings) (33 categories), and lines (11 categories), which should be applied to
the respective layers of OSM PBF files, see \link{osmclass-package} for and example. The classification is optimized
(in terms of tag choice and order of categories) to assign the most sensible primary category to most features in the Africa OSM.
}
\examples{
collapse::unlist2d(osm_point_polygon_class, idcols = c("category", "tag"))
collapse::unlist2d(osm_line_class, idcols = c("category", "tag"))
# This list contains additional tags with information about lines (e.g. roads and railways)
collapse::unlist2d(osm_line_info_tags, idcols = c("category", "tag"))
}
\references{
Krantz, Sebastian, Mapping Africa’s Infrastructure Potential with Geospatial Big Data, Causal ML, and XAI (August 10, 2023). Available at SSRN: https://www.ssrn.com/abstract=4537867
}
\seealso{
\link{osmclass-package}
}
\keyword{datasets}
